/*
 * Decompiled with CFR 0.152.
 */
package io.cryptoapis.utils.rest;

import io.cryptoapis.common_models.ApiError;
import io.cryptoapis.common_models.ApiResponse;
import io.cryptoapis.utils.Utils;
import io.cryptoapis.utils.config.EndpointConfig;
import io.cryptoapis.utils.enums.HttpsRequestsEnum;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import javax.net.ssl.HttpsURLConnection;

public class WebServices {
    public static String formatUrl(String url, EndpointConfig endpointConfig, String endpoint) {
        return MessageFormat.format(url, endpointConfig.getVersion(), endpointConfig.getBlockchain(), endpointConfig.getNetwork(), endpoint);
    }

    public static String formatUrlExchanges(String url, EndpointConfig endpointConfig, String endpoint) {
        return MessageFormat.format(url, endpointConfig.getVersion(), endpoint);
    }

    public static ApiResponse httpsRequest(String url, String httpRequestType, EndpointConfig endpointConfig, String body) {
        HttpsURLConnection conn;
        URL resource;
        try {
            resource = new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
        FilterOutputStream wr = null;
        try {
            conn = (HttpsURLConnection)resource.openConnection();
            conn.setRequestMethod(httpRequestType);
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            conn.setRequestProperty("Connection", "close");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.addRequestProperty("Content-Encoding", "gzip");
            if (endpointConfig != null) {
                conn.setRequestProperty("x-api-key", endpointConfig.getApiKey());
            }
            conn.setDoOutput(true);
            conn.setRequestProperty("User-Agent", "");
            if (httpRequestType.equals(HttpsRequestsEnum.POST.name())) {
                try {
                    wr = new DataOutputStream(conn.getOutputStream());
                }
                catch (Exception e) {
                    return null;
                }
                if (body != null) {
                    ((DataOutputStream)wr).writeBytes(body);
                }
                ((DataOutputStream)wr).flush();
            }
            if (wr != null) {
                wr.close();
            }
        }
        catch (IOException e) {
            return null;
        }
        try {
            return WebServices.httpsResponse(conn, (DataOutputStream)wr, endpointConfig);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ApiResponse httpsResponse(HttpsURLConnection conn, DataOutputStream wr, EndpointConfig endpointConfig) throws IOException {
        BufferedReader in = null;
        ApiResponse apiResponse = new ApiResponse();
        try {
            String inputLine;
            int responseCode = 0;
            try {
                responseCode = conn.getResponseCode();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            apiResponse.setStatusCode(responseCode);
            if (responseCode == 200 || responseCode == 201) {
                try {
                    in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                StringBuilder response = new StringBuilder();
                while (true) {
                    String inputLine2;
                    if ((inputLine2 = in.readLine()) == null) {
                        apiResponse.setResponse(response.toString());
                        ApiResponse apiResponse2 = apiResponse;
                        return apiResponse2;
                    }
                    response.append(inputLine2);
                }
            }
            BufferedReader errorIn = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = errorIn.readLine()) != null) {
                response.append(inputLine);
            }
            errorIn.close();
            ApiError apiError = Utils.convertToApiError(response.toString());
            if (apiError != null) {
                apiError.setStatusCode(responseCode);
                apiResponse.setResponse(apiError.toString());
                ApiResponse apiResponse3 = apiResponse;
                return apiResponse3;
            }
            apiResponse.setResponse(response.toString());
            ApiResponse apiResponse4 = apiResponse;
            return apiResponse4;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

