/*
 * Decompiled with CFR 0.152.
 */
package io.cryptoapis.connections;

import io.cryptoapis.blockchains.ethereum.services.AddressService;
import io.cryptoapis.blockchains.ethereum.services.BlockService;
import io.cryptoapis.blockchains.ethereum.services.BlockchainService;
import io.cryptoapis.blockchains.ethereum.services.ContractService;
import io.cryptoapis.blockchains.ethereum.services.PaymentService;
import io.cryptoapis.blockchains.ethereum.services.TokenService;
import io.cryptoapis.blockchains.ethereum.services.TransactionService;
import io.cryptoapis.blockchains.ethereum.services.WebhookService;
import io.cryptoapis.connections.ConnectionConstructor;
import io.cryptoapis.utils.config.EndpointConfig;

abstract class Ethereum_Based
extends ConnectionConstructor {
    private TransactionService transactionService;
    private BlockService blockService;
    private BlockchainService blockchainService;
    private AddressService addressService;
    private ContractService contractService;
    protected TokenService tokenService;
    private WebhookService webhookService;
    private PaymentService paymentService;

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    public BlockService getBlockService() {
        return this.blockService;
    }

    public BlockchainService getBlockchainService() {
        return this.blockchainService;
    }

    public AddressService getAddressService() {
        return this.addressService;
    }

    public ContractService getContractService() {
        return this.contractService;
    }

    public TokenService getTokenService() {
        return this.tokenService;
    }

    public WebhookService getWebhookService() {
        return this.webhookService;
    }

    public PaymentService getPaymentService() {
        return this.paymentService;
    }

    public Ethereum_Based(EndpointConfig endpointConfig) {
        this.initServices(endpointConfig);
    }

    protected void initServices(EndpointConfig endpointConfig) {
        try {
            this.transactionService = this.getConstructor(TransactionService.class).newInstance(endpointConfig);
            this.blockService = this.getConstructor(BlockService.class).newInstance(endpointConfig);
            this.blockchainService = this.getConstructor(BlockchainService.class).newInstance(endpointConfig);
            this.addressService = this.getConstructor(AddressService.class).newInstance(endpointConfig);
            this.contractService = this.getConstructor(ContractService.class).newInstance(endpointConfig);
            this.tokenService = this.getConstructor(TokenService.class).newInstance(endpointConfig);
            this.webhookService = this.getConstructor(WebhookService.class).newInstance(endpointConfig);
            this.paymentService = this.getConstructor(PaymentService.class).newInstance(endpointConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

