/*
 * Decompiled with CFR 0.152.
 */
package io.cryptoapis.blockchains.ethereum.services;

import io.cryptoapis.abstractServices.AbstractServicesConfig;
import io.cryptoapis.blockchains.ethereum.models.Payment;
import io.cryptoapis.common_models.ApiResponse;
import io.cryptoapis.utils.Utils;
import io.cryptoapis.utils.config.EndpointConfig;
import io.cryptoapis.utils.enums.HttpsRequestsEnum;
import io.cryptoapis.utils.enums.KeyType;
import io.cryptoapis.utils.rest.WebServices;

public class PaymentService
extends AbstractServicesConfig {
    protected static final String PATH = "/{0}/bc/{1}/{2}/payments/{3}";

    public PaymentService(EndpointConfig endpointConfig) {
        super(endpointConfig);
    }

    @Override
    protected String getPath() {
        return PATH;
    }

    public ApiResponse createPFPvt(String from, String to, String callback, String privateKey, Integer confirmations, Long gasPrice, Integer gasLimit) {
        return this.createPF(from, to, callback, KeyType.PrivateKey, privateKey, confirmations, gasPrice, gasLimit);
    }

    public ApiResponse createPFPwd(String from, String to, String callback, String password, Integer confirmations, Long gasPrice, Integer gasLimit) {
        return this.createPF(from, to, callback, KeyType.Password, password, confirmations, gasPrice, gasLimit);
    }

    public ApiResponse deletePF(String paymentID) {
        return Utils.deleteUnit(paymentID, this.url, this.endpointConfig);
    }

    public ApiResponse listPayments() {
        return this.getPayments("");
    }

    public ApiResponse listPastPayments() {
        return this.getPayments("history");
    }

    private ApiResponse getPayments(String endpoint) {
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }

    private ApiResponse createPF(String from, String to, String callback, KeyType keyType, String key, Integer confirmations, Long gasPrice, Integer gasLimit) {
        Payment payment = Payment.createPayment(from, to, callback, keyType, key, confirmations, gasPrice, gasLimit);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, ""), HttpsRequestsEnum.POST.name(), this.endpointConfig, payment.toString());
    }
}

