/*
 * Decompiled with CFR 0.152.
 */
package io.cryptoapis.blockchains.ethereum.services;

import io.cryptoapis.blockchains.ethereum.services.TokenService;
import io.cryptoapis.common_models.ApiError;
import io.cryptoapis.common_models.ApiResponse;
import io.cryptoapis.utils.Utils;
import io.cryptoapis.utils.config.EndpointConfig;
import io.cryptoapis.utils.enums.HttpsRequestsEnum;
import io.cryptoapis.utils.rest.WebServices;
import java.util.Map;
import javafx.util.Pair;

public class EthTokenService
extends TokenService {
    public EthTokenService(EndpointConfig endpointConfig) {
        super(endpointConfig);
    }

    public ApiResponse getAllTokens(Map<String, String> params) {
        String endpoint = "all";
        Pair<String, ApiError> pair = Utils.setQueryParams(params);
        if (pair.getValue() != null) {
            Utils.setApiResponse((ApiError)pair.getValue());
        }
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint.concat((String)pair.getKey())), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }

    public ApiResponse getTokensByAddress(String address) {
        String endpoint = String.format("address/%s", address);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }

    public ApiResponse getTokenTxsByAddress(String address, Map<String, String> params) {
        String endpoint = String.format("address/%s/transfers", address);
        Pair<String, ApiError> pair = Utils.setQueryParams(params);
        if (pair.getValue() != null) {
            Utils.setApiResponse((ApiError)pair.getValue());
        }
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint.concat((String)pair.getKey())), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }
}

