/*
 * Decompiled with CFR 0.152.
 */
package io.cryptoapis.connections;

import io.cryptoapis.blockchains.ethereum.services.EthAddressService;
import io.cryptoapis.blockchains.ethereum.services.EthBlockService;
import io.cryptoapis.blockchains.ethereum.services.EthBlockchainService;
import io.cryptoapis.blockchains.ethereum.services.EthContractService;
import io.cryptoapis.blockchains.ethereum.services.EthPaymentService;
import io.cryptoapis.blockchains.ethereum.services.EthTokenService;
import io.cryptoapis.blockchains.ethereum.services.EthTransactionService;
import io.cryptoapis.blockchains.ethereum.services.EthWebhookService;
import io.cryptoapis.connections.ConnectionConstructor;
import io.cryptoapis.utils.config.EndpointConfig;
import org.apache.log4j.Logger;

public class Ethereum
extends ConnectionConstructor {
    private EthTransactionService ethTransactionService;
    private EthBlockService ethBlockService;
    private EthBlockchainService ethBlockchainService;
    private EthAddressService ethAddressService;
    private EthContractService ethContractService;
    private EthTokenService ethTokenService;
    private EthWebhookService ethWebhookService;
    private EthPaymentService ethPaymentService;
    private static final Logger logger = Logger.getLogger(Ethereum.class);

    public EthTransactionService getEthTransactionService() {
        return this.ethTransactionService;
    }

    public EthBlockService getEthBlockService() {
        return this.ethBlockService;
    }

    public EthBlockchainService getEthBlockchainService() {
        return this.ethBlockchainService;
    }

    public EthAddressService getEthAddressService() {
        return this.ethAddressService;
    }

    public EthContractService getEthContractService() {
        return this.ethContractService;
    }

    public EthTokenService getEthTokenService() {
        return this.ethTokenService;
    }

    public EthWebhookService getWebhookService() {
        return this.ethWebhookService;
    }

    public EthPaymentService getEthPaymentService() {
        return this.ethPaymentService;
    }

    public Ethereum(EndpointConfig endpointConfig) {
        this.initServices(endpointConfig);
    }

    private void initServices(EndpointConfig endpointConfig) {
        try {
            this.ethTransactionService = this.getConstructor(EthTransactionService.class).newInstance(endpointConfig);
            this.ethBlockService = this.getConstructor(EthBlockService.class).newInstance(endpointConfig);
            this.ethBlockchainService = this.getConstructor(EthBlockchainService.class).newInstance(endpointConfig);
            this.ethAddressService = this.getConstructor(EthAddressService.class).newInstance(endpointConfig);
            this.ethContractService = this.getConstructor(EthContractService.class).newInstance(endpointConfig);
            this.ethTokenService = this.getConstructor(EthTokenService.class).newInstance(endpointConfig);
            this.ethWebhookService = this.getConstructor(EthWebhookService.class).newInstance(endpointConfig);
            this.ethPaymentService = this.getConstructor(EthPaymentService.class).newInstance(endpointConfig);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }
}

