/*
 * Decompiled with CFR 0.152.
 */
package io.cryptoapis.connections;

import io.cryptoapis.blockchains.bitcoin_based.services.AddressService;
import io.cryptoapis.blockchains.bitcoin_based.services.BlockService;
import io.cryptoapis.blockchains.bitcoin_based.services.BlockchainService;
import io.cryptoapis.blockchains.bitcoin_based.services.PaymentService;
import io.cryptoapis.blockchains.bitcoin_based.services.TransactionService;
import io.cryptoapis.blockchains.bitcoin_based.services.WalletService;
import io.cryptoapis.blockchains.bitcoin_based.services.WebhookService;
import io.cryptoapis.connections.ConnectionConstructor;
import io.cryptoapis.utils.config.EndpointConfig;
import org.apache.log4j.Logger;

abstract class Bitcoin_Based
extends ConnectionConstructor {
    private TransactionService transactionService;
    private BlockchainService blockchainService;
    private BlockService blockService;
    private AddressService addressService;
    private WalletService walletService;
    private WebhookService webhookService;
    private PaymentService paymentService;
    private static final Logger logger = Logger.getLogger(Bitcoin_Based.class);

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    public BlockchainService getBlockchainService() {
        return this.blockchainService;
    }

    public BlockService getBlockService() {
        return this.blockService;
    }

    public WalletService getWalletService() {
        return this.walletService;
    }

    public AddressService getAddressService() {
        return this.addressService;
    }

    public WebhookService getWebhookService() {
        return this.webhookService;
    }

    public PaymentService getPaymentService() {
        return this.paymentService;
    }

    public Bitcoin_Based(EndpointConfig endpointConfig) {
        this.initServices(endpointConfig);
    }

    private void initServices(EndpointConfig endpointConfig) {
        try {
            this.blockchainService = this.getConstructor(BlockchainService.class).newInstance(endpointConfig);
            this.blockService = this.getConstructor(BlockService.class).newInstance(endpointConfig);
            this.addressService = this.getConstructor(AddressService.class).newInstance(endpointConfig);
            this.walletService = this.getConstructor(WalletService.class).newInstance(endpointConfig);
            this.transactionService = this.getConstructor(TransactionService.class).newInstance(endpointConfig);
            this.webhookService = this.getConstructor(WebhookService.class).newInstance(endpointConfig);
            this.paymentService = this.getConstructor(PaymentService.class).newInstance(endpointConfig);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }
}

