/*
 * Decompiled with CFR 0.152.
 */
package io.cryptoapis.client;

import io.cryptoapis.connections.Bitcoin;
import io.cryptoapis.connections.Bitcoin_Cash;
import io.cryptoapis.connections.Dash;
import io.cryptoapis.connections.Dogecoin;
import io.cryptoapis.connections.Ethereum;
import io.cryptoapis.connections.Exchanges;
import io.cryptoapis.connections.Litecoin;
import io.cryptoapis.utils.config.EndpointConfig;
import io.cryptoapis.utils.constants.CryptoApisConstants;

public class CryptoApis
implements CryptoApisConstants {
    private String apiKey;

    public CryptoApis(String apiKey) {
        this.apiKey = apiKey;
    }

    public Ethereum connectToEth(String network) {
        return new Ethereum(this.setBlockChainConfig("eth", network));
    }

    public Bitcoin connectToBtc(String network) {
        return new Bitcoin(this.setBlockChainConfig("btc", network));
    }

    public Litecoin connectToLtc(String network) {
        return new Litecoin(this.setBlockChainConfig("ltc", network));
    }

    public Bitcoin_Cash connectToBch(String network) {
        return new Bitcoin_Cash(this.setBlockChainConfig("bch", network));
    }

    public Dogecoin connectToDoge(String network) {
        return new Dogecoin(this.setBlockChainConfig("doge", network));
    }

    public Dash connectToDash(String network) {
        return new Dash(this.setBlockChainConfig("dash", network));
    }

    public Exchanges connectToExchanges() {
        return new Exchanges(this.setConfig());
    }

    private EndpointConfig setBlockChainConfig(String blockchain, String network) {
        EndpointConfig newConfig = this.setConfig();
        newConfig.setBlockchain(blockchain);
        newConfig.setNetwork(network);
        return newConfig;
    }

    private EndpointConfig setConfig() {
        return new EndpointConfig("v1", this.apiKey);
    }
}

