/*
 * Decompiled with CFR 0.152.
 */
package io.cryptoapis.blockchains.ethereum.services;

import io.cryptoapis.abstractServices.AbstractServicesConfig;
import io.cryptoapis.blockchains.ethereum.models.EthAccount;
import io.cryptoapis.common_models.ApiError;
import io.cryptoapis.common_models.ApiResponse;
import io.cryptoapis.utils.Utils;
import io.cryptoapis.utils.config.EndpointConfig;
import io.cryptoapis.utils.enums.HttpsRequestsEnum;
import io.cryptoapis.utils.rest.WebServices;
import java.util.Map;
import javafx.util.Pair;

public class EthAddressService
extends AbstractServicesConfig {
    private static final String PATH = "/{0}/bc/{1}/{2}/{3}";
    private static final String ADDRESS = "address";

    public EthAddressService(EndpointConfig endpointConfig) {
        super(endpointConfig);
    }

    @Override
    protected String getPath() {
        return PATH;
    }

    public ApiResponse getAddressInfo(String address) {
        String endpoint = String.format("%s/%s", ADDRESS, address);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }

    public ApiResponse generateNewAddress() {
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, ADDRESS), HttpsRequestsEnum.POST.name(), this.endpointConfig, "");
    }

    public ApiResponse generateAccount(String password) {
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, "account"), HttpsRequestsEnum.POST.name(), this.endpointConfig, EthAccount.createAccount(password).toString());
    }

    public ApiResponse getTxsByAddress(String address, Map<String, String> params) {
        String endpoint = String.format("%s/%s/transactions", ADDRESS, address);
        Pair<String, ApiError> pair = Utils.setQueryParams(params);
        if (pair.getValue() != null) {
            return Utils.setApiResponse((ApiError)pair.getValue());
        }
        return WebServices.httpsRequest(WebServices.formatUrl(this.url.concat((String)pair.getKey()), this.endpointConfig, endpoint), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }

    public ApiResponse getNonce(String address) {
        String endpoint = String.format("%s/%s/nonce", ADDRESS, address);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }
}

