/*
 * Decompiled with CFR 0.152.
 */
package io.cryptoapis.blockchains.bitcoin_based.services;

import io.cryptoapis.abstractServices.AbstractServicesConfig;
import io.cryptoapis.blockchains.bitcoin_based.models.Wallet.HDWallet;
import io.cryptoapis.blockchains.bitcoin_based.models.Wallet.ImportAddress;
import io.cryptoapis.blockchains.bitcoin_based.models.Wallet.Wallet;
import io.cryptoapis.blockchains.bitcoin_based.models.Wallet.XpubAddresses;
import io.cryptoapis.common_models.ApiResponse;
import io.cryptoapis.utils.config.EndpointConfig;
import io.cryptoapis.utils.enums.HttpsRequestsEnum;
import io.cryptoapis.utils.rest.WebServices;
import java.util.List;

public class WalletService
extends AbstractServicesConfig {
    private static final String PATH = "/{0}/bc/{1}/{2}/wallets/{3}";
    private static final String HD = "hd";

    public WalletService(EndpointConfig endpointConfig) {
        super(endpointConfig);
    }

    @Override
    protected String getPath() {
        return PATH;
    }

    public ApiResponse importAddressAsWallet(String walletName, String privateKey, String password, String address) {
        String endpoint = String.format("%s/import", HD);
        ImportAddress importAddress = ImportAddress.importAddressAsWallet(walletName, privateKey, password, address);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.POST.name(), this.endpointConfig, importAddress.toString());
    }

    public ApiResponse createWallet(List<String> addresses, String walletName) {
        Wallet wallet = Wallet.createWallet(addresses, walletName);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, ""), HttpsRequestsEnum.POST.name(), this.endpointConfig, wallet.toString());
    }

    public ApiResponse createHDWallet(String walletName, int addressCount, String password) {
        HDWallet hdWallet = HDWallet.createHDWallet(walletName, addressCount, password);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, HD), HttpsRequestsEnum.POST.name(), this.endpointConfig, hdWallet.toString());
    }

    public ApiResponse listWallets() {
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, ""), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }

    public ApiResponse listHDWallets() {
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, HD), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }

    public ApiResponse getWallet(String walletName) {
        return this.getWallet(walletName, false);
    }

    public ApiResponse getHDWallet(String hdWalletName) {
        return this.getWallet(hdWalletName, true);
    }

    public ApiResponse addAddressToWallet(List<String> addresses, String walletName) {
        Wallet wallet = Wallet.createWallet(addresses, walletName);
        String endpoint = String.format("%s/addresses", walletName);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.POST.name(), this.endpointConfig, wallet.toString());
    }

    public ApiResponse generateAddressWallet(String walletName) {
        return this.generateAddress(walletName, false, "");
    }

    public ApiResponse generateAddressHDWallet(String hdWalletName, int addressCount, String password) {
        HDWallet hdWallet = HDWallet.generateAddress(addressCount, password);
        return this.generateAddress(hdWalletName, true, hdWallet.toString());
    }

    public ApiResponse removeAddress(String walletName, String address) {
        String endpoint = String.format("%s/address/%s", walletName, address);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.DELETE.name(), this.endpointConfig, null);
    }

    public ApiResponse deleteWallet(String wallletName) {
        return this.deleteWallets(wallletName);
    }

    public ApiResponse deleteHDWallet(String hdWallletName) {
        String endpoint = String.format("%s/%s", HD, hdWallletName);
        return this.deleteWallets(endpoint);
    }

    public ApiResponse createExtendedKey(String password) {
        String endpoint = String.format("%s/xpub", HD);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.POST.name(), this.endpointConfig, XpubAddresses.createExtendedKey(password).toString());
    }

    public ApiResponse getXpubReceiveAddresses(String xpub, int from, int to) {
        String endpoint = String.format("%s/xpub/addresses/receive", HD);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.POST.name(), this.endpointConfig, XpubAddresses.getXpubAddresses(xpub, from, to).toString());
    }

    public ApiResponse getXpubChangeAddresses(String xpub, int from, int to) {
        String endpoint = String.format("%s/xpub/addresses/change", HD);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.POST.name(), this.endpointConfig, XpubAddresses.getXpubAddresses(xpub, from, to).toString());
    }

    private ApiResponse getWallet(String walletName, boolean isHD) {
        String endpoint = isHD ? String.format("%s/%s", HD, walletName) : String.format("%s", walletName);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }

    private ApiResponse generateAddress(String walletName, boolean isHD, String body) {
        String generateEndpoint = "addresses/generate";
        String endpoint = isHD ? String.format("%s/%s/%s", HD, walletName, "addresses/generate") : String.format("%s/%s", walletName, "addresses/generate");
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.POST.name(), this.endpointConfig, body);
    }

    private ApiResponse deleteWallets(String path) {
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, path), HttpsRequestsEnum.DELETE.name(), this.endpointConfig, null);
    }
}

