/*
 * Decompiled with CFR 0.152.
 */
package io.cryptoapis.blockchains.bitcoin_based.services;

import io.cryptoapis.abstractServices.AbstractServicesConfig;
import io.cryptoapis.blockchains.bitcoin_based.models.Hex;
import io.cryptoapis.blockchains.bitcoin_based.models.Transaction.CompleteTransaction;
import io.cryptoapis.blockchains.bitcoin_based.models.Transaction.CreateHDWalletTransaction;
import io.cryptoapis.blockchains.bitcoin_based.models.Transaction.CreateTransaction;
import io.cryptoapis.blockchains.bitcoin_based.models.Transaction.SignTransaction;
import io.cryptoapis.common_models.ApiError;
import io.cryptoapis.common_models.ApiResponse;
import io.cryptoapis.utils.Utils;
import io.cryptoapis.utils.config.EndpointConfig;
import io.cryptoapis.utils.enums.HttpsRequestsEnum;
import io.cryptoapis.utils.rest.WebServices;
import java.util.List;
import java.util.Map;
import javafx.util.Pair;

public class TransactionService
extends AbstractServicesConfig {
    private static final String PATH = "/{0}/bc/{1}/{2}/txs/{3}";

    public TransactionService(EndpointConfig endpointConfig) {
        super(endpointConfig);
    }

    @Override
    protected String getPath() {
        return PATH;
    }

    public ApiResponse getTxByHash(String hash) {
        String endpoint = String.format("txid/%s", hash);
        return this.getTransaction(endpoint, null);
    }

    public ApiResponse getTxByBlock(String blockHash, Map<String, String> params) {
        String endpoint = String.format("block/%s", blockHash);
        Pair<String, ApiError> pair = Utils.setQueryParams(params);
        if (pair.getValue() != null) {
            return Utils.setApiResponse((ApiError)pair.getValue());
        }
        return this.getTransaction(endpoint, (String)pair.getKey());
    }

    public ApiResponse getTxByBlock(int blockNumber, Map<String, String> params) {
        String endpoint = String.format("block/%s", blockNumber);
        Pair<String, ApiError> pair = Utils.setQueryParams(params);
        if (pair.getValue() != null) {
            return Utils.setApiResponse((ApiError)pair.getValue());
        }
        return this.getTransaction(endpoint, (String)pair.getKey());
    }

    public ApiResponse getUnconfirmedTxs(Map<String, String> params) {
        Pair<String, ApiError> pair = Utils.setQueryParams(params);
        if (pair.getValue() != null) {
            return Utils.setApiResponse((ApiError)pair.getValue());
        }
        return WebServices.httpsRequest(WebServices.formatUrl(this.url.concat((String)pair.getKey()), this.endpointConfig, "unconfirmed"), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }

    public ApiResponse decodeTx(String hex) {
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, "decode"), HttpsRequestsEnum.POST.name(), this.endpointConfig, Hex.createHex(hex).toString());
    }

    public ApiResponse createTx(List<CreateTransaction.Inputs> inputs, List<CreateTransaction.Outputs> outputs, CreateTransaction.Fee fee, Integer locktime) {
        CreateTransaction createTransaction = CreateTransaction.createTx(inputs, outputs, fee, locktime);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, "create"), HttpsRequestsEnum.POST.name(), this.endpointConfig, createTransaction.toString());
    }

    public ApiResponse signTx(String hex, List<String> wifs) {
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, "sign"), HttpsRequestsEnum.POST.name(), this.endpointConfig, SignTransaction.sign(hex, wifs).toString());
    }

    public ApiResponse sendTx(String hex) {
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, "send"), HttpsRequestsEnum.POST.name(), this.endpointConfig, Hex.createHex(hex).toString());
    }

    public ApiResponse newTx(CreateTransaction createTx, List<String> wifs) {
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, "new"), HttpsRequestsEnum.POST.name(), this.endpointConfig, CompleteTransaction.createSignAndSend(createTx, wifs).toString());
    }

    public ApiResponse newTxWithHDWallet(String walletName, String password, List<CreateTransaction.Inputs> inputs, List<CreateTransaction.Outputs> outputs, CreateTransaction.Fee fee, Integer locktime) {
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, "hdwallet"), HttpsRequestsEnum.POST.name(), this.endpointConfig, CreateHDWalletTransaction.create(walletName, password, inputs, outputs, fee, locktime).toString());
    }

    public ApiResponse getFees() {
        return this.getTransaction("fee", null);
    }

    private ApiResponse getTransaction(String endpoint, String params) {
        if (params != null) {
            this.url = this.url.concat(params);
        }
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }
}

