/*
 * Decompiled with CFR 0.152.
 */
package com.cryptoapis.connections;

import com.cryptoapis.connections.ConnectionConstructor;
import com.cryptoapis.exchanges.services.ExchangeRatesService;
import com.cryptoapis.exchanges.services.MetadataService;
import com.cryptoapis.exchanges.services.OHLCVService;
import com.cryptoapis.exchanges.services.QuotesService;
import com.cryptoapis.exchanges.services.TradesService;
import com.cryptoapis.utils.config.EndpointConfig;
import org.apache.log4j.Logger;

public class Exchanges
extends ConnectionConstructor {
    private static final Logger logger = Logger.getLogger(Exchanges.class);
    private MetadataService metadataService;
    private ExchangeRatesService exchangeRatesService;
    private OHLCVService ohlcvService;
    private TradesService tradesService;
    private QuotesService quotesService;

    public Exchanges(EndpointConfig endpointConfig) {
        this.initServices(endpointConfig);
    }

    public MetadataService getMetadataService() {
        return this.metadataService;
    }

    public ExchangeRatesService getExchangeRatesService() {
        return this.exchangeRatesService;
    }

    public OHLCVService getOhlcvService() {
        return this.ohlcvService;
    }

    public TradesService getTradesService() {
        return this.tradesService;
    }

    public QuotesService getQuotesService() {
        return this.quotesService;
    }

    private void initServices(EndpointConfig endpointConfig) {
        try {
            this.metadataService = this.getConstructor(MetadataService.class).newInstance(endpointConfig);
            this.exchangeRatesService = this.getConstructor(ExchangeRatesService.class).newInstance(endpointConfig);
            this.ohlcvService = this.getConstructor(OHLCVService.class).newInstance(endpointConfig);
            this.tradesService = this.getConstructor(TradesService.class).newInstance(endpointConfig);
            this.quotesService = this.getConstructor(QuotesService.class).newInstance(endpointConfig);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }
}

