/*
 * Decompiled with CFR 0.152.
 */
package com.cryptoapis.client;

import com.cryptoapis.connections.Bitcoin;
import com.cryptoapis.connections.Bitcoin_Cash;
import com.cryptoapis.connections.Dash;
import com.cryptoapis.connections.Dogecoin;
import com.cryptoapis.connections.Ethereum;
import com.cryptoapis.connections.Exchanges;
import com.cryptoapis.connections.Litecoin;
import com.cryptoapis.utils.config.EndpointConfig;
import com.cryptoapis.utils.constants.CryptoApisConstants;

public class CryptoApis
implements CryptoApisConstants {
    private String apiKey;

    public CryptoApis(String apiKey) {
        this.apiKey = apiKey;
    }

    public Ethereum connectToEth(String network) {
        return new Ethereum(this.setBlockChainConfig("eth", network));
    }

    public Bitcoin connectToBtc(String network) {
        return new Bitcoin(this.setBlockChainConfig("btc", network));
    }

    public Litecoin connectToLtc(String network) {
        return new Litecoin(this.setBlockChainConfig("ltc", network));
    }

    public Bitcoin_Cash connectToBch(String network) {
        return new Bitcoin_Cash(this.setBlockChainConfig("bch", network));
    }

    public Dogecoin connectToDoge(String network) {
        return new Dogecoin(this.setBlockChainConfig("doge", network));
    }

    public Dash connectToDash(String network) {
        return new Dash(this.setBlockChainConfig("dash", network));
    }

    public Exchanges connectToExchanges() {
        return new Exchanges(this.setConfig());
    }

    private EndpointConfig setBlockChainConfig(String blockchain, String network) {
        EndpointConfig newConfig = this.setConfig();
        newConfig.setBlockchain(blockchain);
        newConfig.setNetwork(network);
        return newConfig;
    }

    private EndpointConfig setConfig() {
        return new EndpointConfig("v1", this.apiKey);
    }
}

