/*
 * Decompiled with CFR 0.152.
 */
package com.cryptoapis.blockchains.ethereum.services;

import com.cryptoapis.abstractServices.AbstractServicesConfig;
import com.cryptoapis.blockchains.bitcoin_based.models.Hex;
import com.cryptoapis.blockchains.ethereum.models.EthRawTransaction;
import com.cryptoapis.common_models.ApiError;
import com.cryptoapis.common_models.ApiResponse;
import com.cryptoapis.utils.Utils;
import com.cryptoapis.utils.config.EndpointConfig;
import com.cryptoapis.utils.enums.HttpsRequestsEnum;
import com.cryptoapis.utils.enums.KeyType;
import com.cryptoapis.utils.rest.WebServices;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import javafx.util.Pair;

public class EthTransactionService
extends AbstractServicesConfig {
    private static final String PATH = "/{0}/bc/{1}/{2}/txs/{3}";

    public EthTransactionService(EndpointConfig endpointConfig) {
        super(endpointConfig);
    }

    @Override
    protected String getPath() {
        return PATH;
    }

    public ApiResponse getInternalTxs(String hash) {
        String endpoint = String.format("hash/%s/internal", hash);
        return this.getApiResponse(endpoint);
    }

    public ApiResponse getTx(String hash) {
        String endpoint = String.format("hash/%s", hash);
        return this.getApiResponse(endpoint);
    }

    public ApiResponse getTx(int blockNumber, int index) {
        String endpoint = String.format("block/%s/%s", blockNumber, index);
        return this.getApiResponse(endpoint);
    }

    public ApiResponse getTx(String blockHash, int index) {
        String endpoint = String.format("block/%s/%s", blockHash, index);
        return this.getApiResponse(endpoint);
    }

    public ApiResponse getPendingTxs() {
        return this.getApiResponse("pending");
    }

    public ApiResponse getQueuedTxs() {
        return this.getApiResponse("queued");
    }

    public ApiResponse getTxByIdxAndLimit(int blockNumber, Map<String, String> params) {
        String endpoint = String.format("block/%s", blockNumber);
        Pair<String, ApiError> pair = Utils.setQueryParams(params);
        if (pair.getValue() != null) {
            Utils.setApiResponse((ApiError)pair.getValue());
        }
        return this.getApiResponse(endpoint.concat((String)pair.getKey()));
    }

    public ApiResponse createTxKeyStore(String from, String to, BigInteger gasPrice, BigInteger gasLimit, BigDecimal value, String data, String password) {
        return this.setRawTransactionBody(from, to, gasPrice, gasLimit, value, data, KeyType.Password, password, "new");
    }

    public ApiResponse createTxKeyStoreAll(String from, String to, BigInteger gasPrice, BigInteger gasLimit, String data, String password) {
        return this.setRawTransactionBody(from, to, gasPrice, gasLimit, data, KeyType.Password, password, "new/all");
    }

    public ApiResponse createTxPvt(String from, String to, BigInteger gasPrice, BigInteger gasLimit, BigDecimal value, String data, String privateKey) {
        return this.setRawTransactionBody(from, to, gasPrice, gasLimit, value, data, KeyType.PrivateKey, privateKey, "new-pvtkey");
    }

    public ApiResponse createTxPvtAll(String from, String to, BigInteger gasPrice, BigInteger gasLimit, String data, String privateKey) {
        return this.setRawTransactionBody(from, to, gasPrice, gasLimit, data, KeyType.PrivateKey, privateKey, "new-pvtkey/all");
    }

    public ApiResponse getRawTxBody(String from, String to, BigDecimal value, String data) {
        return this.setRawTransactionBody(from, to, value, data, "send");
    }

    public ApiResponse estimateGasLimit(String from, String to, BigDecimal value, String data) {
        return this.setRawTransactionBody(from, to, value, data, "gas");
    }

    public ApiResponse broadcastSignedTx(String hex) {
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, "push"), HttpsRequestsEnum.POST.name(), this.endpointConfig, Hex.createHex(hex).toString());
    }

    public ApiResponse getGasFees() {
        return this.getApiResponse("fee");
    }

    private ApiResponse setRawTransactionBody(String from, String to, BigInteger gasPrice, BigInteger gasLimit, BigDecimal value, String data, KeyType keyType, String key, String endpoint) {
        EthRawTransaction ethRawTransaction = EthRawTransaction.createTransaction(from, to, gasPrice, gasLimit, value, data, keyType, key);
        return this.sendTx(endpoint, ethRawTransaction);
    }

    private ApiResponse setRawTransactionBody(String from, String to, BigDecimal value, String data, String endpoint) {
        EthRawTransaction ethRawTransaction = EthRawTransaction.createTransaction(from, to, value, data);
        return this.sendTx(endpoint, ethRawTransaction);
    }

    private ApiResponse setRawTransactionBody(String from, String to, BigInteger gasPrice, BigInteger gasLimit, String data, KeyType keyType, String key, String endpoint) {
        EthRawTransaction ethRawTransaction = EthRawTransaction.createTransaction(from, to, gasPrice, gasLimit, data, keyType, key);
        return this.sendTx(endpoint, ethRawTransaction);
    }

    private ApiResponse getApiResponse(String endpoint) {
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }

    private ApiResponse sendTx(String endpoint, EthRawTransaction ethRawTransaction) {
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.POST.name(), this.endpointConfig, ethRawTransaction.toString());
    }
}

