/*
 * Decompiled with CFR 0.152.
 */
package com.cryptoapis.blockchains.bitcoin_based.services;

import com.cryptoapis.abstractServices.AbstractServicesConfig;
import com.cryptoapis.blockchains.bitcoin_based.models.Payment;
import com.cryptoapis.common_models.ApiResponse;
import com.cryptoapis.utils.Utils;
import com.cryptoapis.utils.config.EndpointConfig;
import com.cryptoapis.utils.enums.HttpsRequestsEnum;
import com.cryptoapis.utils.rest.WebServices;

public class PaymentService
extends AbstractServicesConfig {
    private static final String PATH = "/{0}/bc/{1}/{2}/payments/{3}";

    protected PaymentService(EndpointConfig endpointConfig) {
        super(endpointConfig);
    }

    @Override
    protected String getPath() {
        return PATH;
    }

    public ApiResponse createPFPwd(String from, String to, String callback, String walletName, String password, Integer confirmations, Double fee) {
        Payment payment = this.createPF(from, to, callback, walletName, password, confirmations, fee);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, ""), HttpsRequestsEnum.POST.name(), this.endpointConfig, payment.toString());
    }

    public ApiResponse deletePF(String paymentID) {
        return Utils.deleteUnit(paymentID, this.url, this.endpointConfig);
    }

    public ApiResponse listPayments() {
        return this.getPayments("");
    }

    public ApiResponse listPastPayments() {
        return this.getPayments("history");
    }

    private Payment createPF(String from, String to, String callback, String walletName, String password, Integer confirmations, Double fee) {
        return Payment.createPayment(from, to, callback, walletName, password, confirmations, fee);
    }

    private ApiResponse getPayments(String endpoint) {
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }
}

