/*
 * Decompiled with CFR 0.152.
 */
package com.cryptoapis.blockchains.ethereum.services;

import com.cryptoapis.abstractServices.AbstractServicesConfig;
import com.cryptoapis.blockchains.ethereum.models.EthTokenTransfer;
import com.cryptoapis.common_models.ApiError;
import com.cryptoapis.common_models.ApiResponse;
import com.cryptoapis.utils.Utils;
import com.cryptoapis.utils.config.EndpointConfig;
import com.cryptoapis.utils.enums.HttpsRequestsEnum;
import com.cryptoapis.utils.enums.KeyType;
import com.cryptoapis.utils.rest.WebServices;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import javafx.util.Pair;

public class EthTokenService
extends AbstractServicesConfig {
    private static final String PATH = "/{0}/bc/{1}/{2}/tokens/{3}";

    public EthTokenService(EndpointConfig endpointConfig) {
        super(endpointConfig);
    }

    @Override
    protected String getPath() {
        return PATH;
    }

    public ApiResponse getAllTokens(Map<String, String> params) {
        String endpoint = "all";
        Pair<String, ApiError> pair = Utils.setQueryParams(params);
        if (pair.getValue() != null) {
            Utils.setApiResponse((ApiError)pair.getValue());
        }
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint.concat((String)pair.getKey())), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }

    public ApiResponse getTokenBalance(String address, String contract) {
        String endpoint = String.format("%s/%s/balance", address, contract);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }

    public ApiResponse transferPvt(String fromAddress, String toAddress, String contract, BigInteger gasPrice, BigInteger gasLimit, BigDecimal token, String privateKey) {
        String body = this.createTokenTransaction(fromAddress, toAddress, contract, gasPrice, gasLimit, token, KeyType.PrivateKey, privateKey);
        return this.broadcastTransfer(body);
    }

    public ApiResponse transferPwd(String fromAddress, String toAddress, String contract, BigInteger gasPrice, BigInteger gasLimit, BigDecimal token, String password) {
        String body = this.createTokenTransaction(fromAddress, toAddress, contract, gasPrice, gasLimit, token, KeyType.Password, password);
        return this.broadcastTransfer(body);
    }

    public ApiResponse getTokensByAddress(String address) {
        String endpoint = String.format("address/%s", address);
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }

    public ApiResponse getTokenTxsByAddress(String address, Map<String, String> params) {
        String endpoint = String.format("address/%s/transfers", address);
        Pair<String, ApiError> pair = Utils.setQueryParams(params);
        if (pair.getValue() != null) {
            Utils.setApiResponse((ApiError)pair.getValue());
        }
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint.concat((String)pair.getKey())), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }

    private String createTokenTransaction(String fromAddress, String toAddress, String contract, BigInteger gasPrice, BigInteger gasLimit, BigDecimal token, KeyType keyType, String key) {
        EthTokenTransfer ethToken = EthTokenTransfer.createTokenTransaction(fromAddress, toAddress, contract, gasPrice, gasLimit, token, keyType, key);
        return ethToken.toString();
    }

    private ApiResponse broadcastTransfer(String body) {
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, "transfer"), HttpsRequestsEnum.POST.name(), this.endpointConfig, body);
    }
}

