/*
 * Decompiled with CFR 0.152.
 */
package com.cryptoapis.blockchains.ethereum.services;

import com.cryptoapis.abstractServices.AbstractServicesConfig;
import com.cryptoapis.common_models.ApiResponse;
import com.cryptoapis.utils.config.EndpointConfig;
import com.cryptoapis.utils.enums.HttpsRequestsEnum;
import com.cryptoapis.utils.rest.WebServices;

public class EthBlockService
extends AbstractServicesConfig {
    private static final String PATH = "/{0}/bc/{1}/{2}/blocks/{3}";

    public EthBlockService(EndpointConfig endpointConfig) {
        super(endpointConfig);
    }

    @Override
    protected String getPath() {
        return PATH;
    }

    public ApiResponse getBlock(String blockHash) {
        return this.fetchBlock(blockHash);
    }

    public ApiResponse getBlock(int blockNumber) {
        return this.fetchBlock(String.format("%s", blockNumber));
    }

    public ApiResponse getLatestBlock() {
        return this.fetchBlock("latest");
    }

    private ApiResponse fetchBlock(String endpoint) {
        return WebServices.httpsRequest(WebServices.formatUrl(this.url, this.endpointConfig, endpoint), HttpsRequestsEnum.GET.name(), this.endpointConfig, null);
    }
}

