/*
 * Decompiled with CFR 0.152.
 */
package io.crowdcode.webdav.data;

import io.crowdcode.webdav.data.WebDavElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDavFileInputStream
extends InputStream
implements WebDavElement {
    private static final Logger log = LoggerFactory.getLogger(WebDavFileInputStream.class);
    private final DavPropertySet propertiesPresent;
    private final InputStream inputStream;
    private final File tmpFile;

    public WebDavFileInputStream(DavPropertySet propertiesPresent, InputStream inputStream, File tmpFile) {
        this.propertiesPresent = propertiesPresent;
        this.tmpFile = tmpFile;
        this.inputStream = this.loadingInputStreamToTmpFile(inputStream, tmpFile);
    }

    private InputStream loadingInputStreamToTmpFile(InputStream inputStream, File tmpFile) {
        try (FileOutputStream outputStream = new FileOutputStream(tmpFile);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            log.error("Couldn't load file {} due to io exception.", (Object)tmpFile, (Object)e);
        }
        try {
            return new FileInputStream(tmpFile);
        }
        catch (FileNotFoundException e) {
            log.error("Cannot open input stream of local file {}", (Object)tmpFile, (Object)e);
            return null;
        }
    }

    @Override
    public DavPropertySet getPropertiesPresent() {
        return this.propertiesPresent;
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.inputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.inputStream.read(b, off, len);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        return this.inputStream.readAllBytes();
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        return this.inputStream.readNBytes(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        this.tmpFile.delete();
    }

    @Override
    public void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        return this.inputStream.transferTo(out);
    }
}

