/*
 * Decompiled with CFR 0.152.
 */
package io.crowdcode.webdav.data;

import io.crowdcode.webdav.data.WebDavElement;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.jackrabbit.webdav.property.DavPropertySet;

public class WebDavFile
implements WebDavElement {
    private final URI baseURI;
    private final DavPropertySet propertiesPresent;

    public WebDavFile(URI baseURI, DavPropertySet propertiesPresent) {
        this.baseURI = baseURI;
        this.propertiesPresent = propertiesPresent;
    }

    public String getCreated() {
        return this.propertiesPresent.get("creationdate").getValue().toString();
    }

    public String getLastModified() {
        return this.propertiesPresent.get("getlastmodified").getValue().toString();
    }

    public String getContentType() {
        return this.propertiesPresent.get("getcontenttype").getValue().toString();
    }

    public Integer getLength() {
        return Integer.valueOf(this.propertiesPresent.get("getcontentlength").getValue().toString());
    }

    public String getNameUrlEncoded() {
        try {
            return URLEncoder.encode(this.getName(), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public URI getURI() {
        String b = this.baseURI.toString();
        return URI.create(b.endsWith("/") ? b + this.getNameUrlEncoded() : b + "/" + this.getNameUrlEncoded());
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    @Override
    public DavPropertySet getPropertiesPresent() {
        return this.propertiesPresent;
    }
}

