/*
 * Decompiled with CFR 0.152.
 */
package io.crowdcode.webdav;

import io.crowdcode.webdav.data.WebDavDirectory;
import io.crowdcode.webdav.data.WebDavFile;
import io.crowdcode.webdav.data.WebDavFileInputStream;
import io.crowdcode.webdav.data.WebDavLsResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.HttpMkcol;
import org.apache.jackrabbit.webdav.client.methods.HttpOptions;
import org.apache.jackrabbit.webdav.client.methods.HttpPropfind;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRWebDavClient {
    private static final Logger logger = LoggerFactory.getLogger(JRWebDavClient.class);
    private HttpClientContext context;
    private CloseableHttpClient client;
    private String root;
    private URI baseUri;

    public void init(URI uri, String username, String password) {
        this.root = uri.toASCIIString();
        if (!this.root.endsWith("/")) {
            this.root = this.root + "/";
        }
        this.baseUri = uri;
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        HttpHost targetHost = new HttpHost(uri.getHost(), uri.getPort());
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(targetHost, (AuthScheme)basicAuth);
        this.context = HttpClientContext.create();
        this.context.setCredentialsProvider((CredentialsProvider)credsProvider);
        this.context.setAuthCache((AuthCache)authCache);
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    public Set<String> getDavComplianceClasses(URI uri) throws IOException {
        HttpOptions options = new HttpOptions(uri);
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)options, (HttpContext)this.context);
        int status = response.getStatusLine().getStatusCode();
        if (!Integer.valueOf(200).equals(status)) {
            logger.error("ERROR! INSTEAD OF HTTP 200 I GOT {}", (Object)status);
            throw new DavAccessFailedException("EXPECTED HTTP 200. GOT " + status);
        }
        Set allow = options.getAllowedMethods((HttpResponse)response);
        Set complianceClasses = options.getDavComplianceClasses((HttpResponse)response);
        return complianceClasses;
    }

    public WebDavFileInputStream readFile(WebDavFile file) {
        WebDavFileInputStream result = null;
        try {
            File tmp = File.createTempFile(file.getName() + "-", ".tmp");
            logger.debug("Using temporal file {}", (Object)tmp);
            tmp.deleteOnExit();
            URI source = file.getURI();
            HttpGet get = new HttpGet(source);
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)get);
            int status = response.getStatusLine().getStatusCode();
            if (status != 200) {
                logger.error("ERROR! INSTEAD OF HTTP 200 I GOT {}", (Object)status);
                throw new DavAccessFailedException("EXPECTED HTTP 200. GOT " + status);
            }
            InputStream stream = response.getEntity().getContent();
            result = new WebDavFileInputStream(file.getPropertiesPresent(), stream, tmp);
        }
        catch (IOException e) {
            logger.error("Error while reading file", (Throwable)e);
        }
        return result;
    }

    public WebDavLsResult ls(String resource) throws IOException, DavException {
        MultiStatusResponse[] responses;
        WebDavLsResult result = new WebDavLsResult();
        DavPropertyNameSet set = new DavPropertyNameSet();
        set.add(DavPropertyName.create((String)"displayname"));
        set.add(DavPropertyName.create((String)"resourcetype"));
        set.add(DavPropertyName.create((String)"source"));
        set.add(DavPropertyName.create((String)"getcontentlength"));
        set.add(DavPropertyName.create((String)"getcontenttype"));
        set.add(DavPropertyName.create((String)"creationdate"));
        set.add(DavPropertyName.create((String)"getlastmodified"));
        String uri = this.baseUri.toString() + ("/" + resource).replace("//", "/");
        URI baseURI = URI.create(uri);
        HttpPropfind propfind = new HttpPropfind(uri, set, 1);
        CloseableHttpResponse resp = this.client.execute((HttpUriRequest)propfind, (HttpContext)this.context);
        int status = resp.getStatusLine().getStatusCode();
        if (status / 100 != 2) {
            throw new DavAccessFailedException("Access to " + propfind.toString() + " failed with a non 2xx status. Status was " + status);
        }
        MultiStatus multistatus = propfind.getResponseBodyAsMultiStatus((HttpResponse)resp);
        for (MultiStatusResponse respons : responses = multistatus.getResponses()) {
            DavPropertySet found = respons.getProperties(200);
            DavPropertySet notfound = respons.getProperties(404);
            if (notfound.contains(DavPropertyName.GETCONTENTLENGTH)) {
                result.addDirectory(new WebDavDirectory(baseURI, found));
                continue;
            }
            result.addFile(new WebDavFile(baseURI, found));
        }
        return result;
    }

    public WebDavDirectory mkdir(String resource) throws IOException, DavException {
        String uri = this.baseUri.toString() + ("/" + resource).replace("//", "/");
        HttpMkcol mkcol = new HttpMkcol(uri);
        CloseableHttpResponse resp = this.client.execute((HttpUriRequest)mkcol, (HttpContext)this.context);
        int status = resp.getStatusLine().getStatusCode();
        if (status / 100 != 2) {
            throw new DavAccessFailedException("Access to " + mkcol.toString() + " failed with a non 2xx status. Status was " + status);
        }
        WebDavLsResult webDavLsResult = this.ls(resource);
        List<WebDavDirectory> webDavDirectories = webDavLsResult.getDirectories();
        if (webDavDirectories.isEmpty()) {
            throw new DavAccessFailedException("Directory " + mkcol.toString() + " will not be found.");
        }
        return webDavDirectories.get(0);
    }

    public WebDavFile put(byte[] content, String fileName) throws IOException, DavException {
        String uri = this.baseUri.toString() + ("/" + fileName).replace("//", "/");
        HttpPut httpPut = new HttpPut(uri);
        ByteArrayEntity entity = new ByteArrayEntity(content);
        httpPut.setEntity((HttpEntity)entity);
        CloseableHttpResponse resp = this.client.execute((HttpUriRequest)httpPut, (HttpContext)this.context);
        int status = resp.getStatusLine().getStatusCode();
        if (status / 100 != 2) {
            throw new DavAccessFailedException("Access to " + httpPut.toString() + " failed with a non 2xx status. Status was " + status);
        }
        WebDavLsResult webDavLsResult = this.ls(fileName);
        List<WebDavFile> webDavFileList = webDavLsResult.getFiles();
        if (webDavFileList.isEmpty()) {
            throw new DavAccessFailedException("No File " + httpPut.toString() + " will be found.");
        }
        return webDavFileList.get(0);
    }

    public static final class DavAccessFailedException
    extends RuntimeException {
        public DavAccessFailedException(String message) {
            super(message);
        }
    }
}

