/*
 * Decompiled with CFR 0.152.
 */
package io.crowdcode.maven.plugins.rancher;

import io.crowdcode.maven.plugins.rancher.Stack;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Mojo(defaultPhase=LifecyclePhase.PROCESS_SOURCES, name="stack-deploy")
@Execute(phase=LifecyclePhase.PROCESS_SOURCES, goal="stack-deploy")
public class RancherApiMojo
extends AbstractMojo {
    private static final Logger log = LoggerFactory.getLogger(RancherApiMojo.class);
    private static final int MAX_STACK_NAME_LENGTH = 63;
    private RestTemplate restTemplate = new RestTemplate();
    @Parameter(required=true)
    private String accessKey;
    @Parameter(required=true)
    private String password;
    @Parameter(required=true)
    private String url;
    @Parameter(required=true)
    private String environment;
    @Parameter(property="stack", required=true)
    private Stack stack;
    @Parameter
    private boolean skip = false;

    public RancherApiMojo() {
        this.restTemplate.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
    }

    private HttpHeaders createBasicAuthHeaders() {
        HttpHeaders headers = new HttpHeaders();
        String auth = this.accessKey + ":" + this.password;
        byte[] encodedAuth = Base64Utils.encode((byte[])auth.getBytes());
        String authHeader = "Basic " + new String(encodedAuth);
        headers.set("Authorization", authHeader);
        return headers;
    }

    private String getEnvironment() {
        String envUrl = this.url + "/projects?name=" + this.environment;
        ResponseEntity responseEntity = this.restTemplate.exchange(envUrl, HttpMethod.GET, new HttpEntity((MultiValueMap)this.createBasicAuthHeaders()), String.class, new Object[0]);
        String responseBody = (String)responseEntity.getBody();
        Assert.notNull((Object)responseBody, (String)("No http response body for url: " + envUrl));
        Assert.isTrue((!responseBody.isEmpty() ? 1 : 0) != 0, (String)("No http response body for url: " + envUrl));
        return responseBody;
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        if (this.stack.getName().length() > 63) {
            this.stack.setName(this.stack.getName().substring(0, 62));
            log.warn("Stackname to long, truncated to: \"" + this.stack.getName() + "\"");
        }
        Assert.notNull((Object)this.stack, (String)"stack not defined");
        if (this.stack.init(this.restTemplate, this.createBasicAuthHeaders(), this.getEnvironment(), this.environment)) {
            this.stack.run();
        }
    }
}

