/*
 * Decompiled with CFR 0.152.
 */
package io.crowdcode.maven.plugins.rancher;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.crowdcode.maven.plugins.rancher.StackModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import net.minidev.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class Stack
extends StackModel {
    private static final Logger log = LoggerFactory.getLogger(Stack.class);
    String stacksUrl;
    private RestTemplate restTemplate;
    private HttpHeaders headers;
    private String url;

    public boolean init(RestTemplate restTemplate, HttpHeaders headers, String environmentResponse, String environment) {
        block3: {
            this.restTemplate = restTemplate;
            this.headers = headers;
            DocumentContext ctx = JsonPath.parse((String)environmentResponse);
            try {
                JSONArray data = (JSONArray)ctx.read("data", new Predicate[0]);
                if (data.size() != 0) {
                    this.url = (String)ctx.read("data[0].links.self", new Predicate[0]);
                    this.stacksUrl = (String)ctx.read("data[0].links.stacks", new Predicate[0]);
                    ResponseEntity responseEntity = restTemplate.exchange(this.stacksUrl + "?name=" + this.getName(), HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
                    ctx = JsonPath.parse((String)((String)responseEntity.getBody()));
                    data = (JSONArray)ctx.read("data", new Predicate[0]);
                    this.url = data.size() != 0 ? (String)ctx.read("data[0].links.self", new Predicate[0]) : "";
                    break block3;
                }
                log.error("access to environment {} not possible", (Object)environment);
                return false;
            }
            catch (RuntimeException ex) {
                log.info("The stack {} at environment {} does not exists {}", new Object[]{this.getName(), environment, ex});
            }
        }
        return true;
    }

    private void removeStack() {
        if (this.url != null && !this.url.isEmpty()) {
            String stackUrl = this.url + "?action=remove";
            log.info("About to delete the stack: {}", (Object)stackUrl);
            try {
                this.restTemplate.exchange(stackUrl, HttpMethod.POST, new HttpEntity((MultiValueMap)this.headers), String.class, new Object[0]);
                log.info("Stack {} successfully deleted", (Object)stackUrl);
                this.url = "";
            }
            catch (RuntimeException ex) {
                log.error("Error while remove stack", (Throwable)ex);
            }
        } else {
            log.info("Stack " + this.getName() + " does not exist!");
        }
    }

    private String readComposeFile(File composeFile) {
        if (composeFile != null && composeFile.exists() && composeFile.canRead()) {
            try {
                return new String(Files.readAllBytes(Paths.get(composeFile.toURI())));
            }
            catch (IOException ex) {
                log.error("Error while reading the compose file: {}", (Object)composeFile.getAbsolutePath(), (Object)ex);
            }
        }
        return null;
    }

    private void createStack() {
        String dockerComposeContent = this.readComposeFile(this.getDockerComposeFile());
        String rancherComposeContent = this.readComposeFile(this.getRancherComposeFile());
        Assert.notNull((Object)dockerComposeContent, (String)("dockerComposeContent " + this.getDockerComposeFile() + " can not be found"));
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("description", this.getDescription());
        payload.put("dockerCompose", dockerComposeContent);
        if (rancherComposeContent != null) {
            payload.put("rancherCompose", rancherComposeContent);
        }
        payload.put("name", this.getName());
        payload.put("startOnCreate", this.getStartOnCreate());
        this.headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = null;
        try {
            entity = new HttpEntity((Object)new ObjectMapper().writeValueAsString(payload), (MultiValueMap)this.headers);
        }
        catch (JsonProcessingException ex) {
            log.error("Error while parsing stack payload to json", (Throwable)ex);
        }
        log.info("About to create new stack with url: {} and payload: {}", (Object)this.stacksUrl, payload);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(this.stacksUrl, HttpMethod.POST, entity, String.class, new Object[0]);
            DocumentContext ctx = JsonPath.parse((String)((String)responseEntity.getBody()));
            this.url = (String)ctx.read("links.self", new Predicate[0]);
            log.info("New stack successfully created");
        }
        catch (RuntimeException ex) {
            log.error("Error while parsing stack payload to json {}", (Throwable)ex);
            throw ex;
        }
    }

    private void wait(String action) {
        if (action.matches("[0-9]*")) {
            long timeout = Long.parseLong(action);
            try {
                log.info("wait() waiting {} millis", (Object)timeout);
                Thread.sleep(timeout);
            }
            catch (InterruptedException ex) {
                log.error("Error while wait sleeping", (Throwable)ex);
            }
        } else {
            log.info("missing time uses wait:NNNN");
        }
    }

    private String verify() {
        if (this.url != null && !this.url.isEmpty()) {
            log.info("Verify the stack: {}", (Object)this.getName());
            try {
                ResponseEntity responseEntity = this.restTemplate.exchange(this.url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.headers), String.class, new Object[0]);
                DocumentContext ctx = JsonPath.parse((String)((String)responseEntity.getBody()));
                String state = (String)ctx.read("state", new Predicate[0]);
                log.info("State={}", (Object)state);
                return state;
            }
            catch (RuntimeException ex) {
                log.error("Error while verifying stack", (Throwable)ex);
                throw ex;
            }
        }
        log.info("Stack " + this.getName() + " does not exist!");
        return "";
    }

    private void verifyStack(String action) {
        long timeout;
        long runtime;
        int paramCount = 0;
        String[] param = null;
        if (!action.isEmpty()) {
            param = action.split(":");
            paramCount = param.length;
        }
        String state = "";
        int devider = 10;
        switch (paramCount) {
            case 0: {
                state = this.verify();
                Assert.isTrue((boolean)"active".equals(state), (String)"Stack not at state active");
                return;
            }
            case 2: {
                devider = Integer.parseInt(param[1]);
            }
            case 1: {
                runtime = Long.parseLong(param[0]);
                timeout = System.currentTimeMillis() + runtime;
                break;
            }
            default: {
                log.error("Error while parsing verify parameters");
                throw new IllegalArgumentException("Error while parsing verify parameters");
            }
        }
        long sleeptime = runtime / (long)devider;
        while (!"active".equals(state) && System.currentTimeMillis() < timeout) {
            try {
                log.info("verifyStack() waiting {} millis", (Object)sleeptime);
                Thread.sleep(sleeptime);
            }
            catch (InterruptedException ex) {
                log.error("Error while verify sleeping)", (Throwable)ex);
                throw new RuntimeException(ex);
            }
            state = this.verify();
        }
        if (!"active".equals(state)) {
            throw new BadStateException("Stack not at state active");
        }
    }

    public void run() {
        String[] actions;
        block12: for (String action : actions = this.getActions().split(",")) {
            String a;
            String param = "";
            if (action.contains(":")) {
                a = action.split(":")[0];
                param = action.split(":", 2)[1];
            } else {
                a = action;
            }
            switch (a.toLowerCase()) {
                case "remove": {
                    this.removeStack();
                    continue block12;
                }
                case "wait": {
                    this.wait(param);
                    continue block12;
                }
                case "create": {
                    this.createStack();
                    continue block12;
                }
                case "verify": {
                    this.verifyStack(param);
                    continue block12;
                }
                default: {
                    log.error("Stack unknown action " + a);
                }
            }
        }
    }

    private static final class BadStateException
    extends RuntimeException {
        public BadStateException(String message) {
            super(message);
        }
    }
}

