/*
 * Decompiled with CFR 0.152.
 */
package io.crowdcode.bgav;

import io.crowdcode.bgav.MavenHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLHandler {
    private final Log log;
    private final boolean suppressCommit;

    public XMLHandler(boolean suppresCommit) {
        this.suppressCommit = suppresCommit;
        this.log = null;
    }

    public XMLHandler(Log log, boolean suppresCommit) {
        this.log = log;
        this.suppressCommit = suppresCommit;
    }

    void writeChangedPomWithXPath(File pomfile, String ticketID) throws MojoExecutionException {
        try (FileInputStream fileInputStream = new FileInputStream(pomfile);){
            Document document = this.getDocument(fileInputStream);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String expression = "/project/version";
            NodeList nodeList = (NodeList)xPath.compile(expression).evaluate(document, XPathConstants.NODESET);
            String oldPomVersion = nodeList.item(0).getTextContent();
            nodeList.item(0).setTextContent(new MavenHandler(this.log, this.suppressCommit).setPomVersion(oldPomVersion, ticketID));
            this.writePomFile(pomfile, document);
        }
        catch (Exception ex) {
            this.log.error((CharSequence)("IOException: " + ex));
            throw new MojoExecutionException("could not write POM: " + ex);
        }
    }

    void writeNonBgavPomWithXPath(File pomfile, String pomVersion) throws MojoExecutionException {
        try (FileInputStream fileInputStream = new FileInputStream(pomfile);){
            Document document = this.getDocument(fileInputStream);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String expression = "/project/version";
            NodeList nodeList = (NodeList)xPath.compile(expression).evaluate(document, XPathConstants.NODESET);
            String oldPomVersion = nodeList.item(0).getTextContent();
            nodeList.item(0).setTextContent(pomVersion);
            this.writePomFile(pomfile, document);
        }
        catch (Exception ex) {
            this.log.error((CharSequence)("IOException: " + ex));
            throw new MojoExecutionException("could not write POM: " + ex);
        }
    }

    void alterDependency(File pomfile, String artifact, String newVersion) throws MojoExecutionException {
        try (FileInputStream fileInputStream = new FileInputStream(pomfile);){
            Document document = this.getDocument(fileInputStream);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String expression = "//dependencies/dependency";
            NodeList nodeList = (NodeList)xPath.compile(expression).evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!nodeList.item(i).getTextContent().contains(artifact)) continue;
                NodeList children = nodeList.item(i).getChildNodes();
                this.log.info((CharSequence)("found artifact: " + artifact + ", change version " + newVersion));
                for (int j = 0; j < children.getLength(); ++j) {
                    if (children.item(j).getNodeType() != 1 || !children.item(j).getNodeName().equalsIgnoreCase("version")) continue;
                    String oldPomVersion = children.item(j).getTextContent();
                    children.item(j).setTextContent(newVersion);
                }
            }
            this.writePomFile(pomfile, document);
        }
        catch (Exception ex) {
            this.log.error((CharSequence)("IOException: " + ex));
            throw new MojoExecutionException("could not write POM: " + ex);
        }
    }

    private void writePomFile(File pomfile, Document document) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(new DOMSource(document), new StreamResult(pomfile));
    }

    void alterProperty(File pomfile, String propertyName, String targetPomVersion) throws MojoExecutionException {
        try (FileInputStream fileInputStream = new FileInputStream(pomfile);){
            Document document = this.getDocument(fileInputStream);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String expression = "//properties";
            NodeList nodeList = (NodeList)xPath.compile(expression).evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node item = nodeList.item(i);
                NodeList childNodes = item.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node child = childNodes.item(j);
                    if (!child.getNodeName().equals(propertyName)) continue;
                    this.log.info((CharSequence)("found property: " + propertyName + ", change to version " + targetPomVersion));
                    child.setTextContent(targetPomVersion);
                }
            }
            this.writePomFile(pomfile, document);
        }
        catch (Exception ex) {
            this.log.error((CharSequence)("IOException: " + ex));
            throw new MojoExecutionException("could not write POM: " + ex);
        }
    }

    private Document getDocument(FileInputStream fileInputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(fileInputStream);
    }
}

