/*
 * Decompiled with CFR 0.152.
 */
package io.crowdcode.bgav;

import io.crowdcode.bgav.FileHelper;
import io.crowdcode.bgav.GitHandler;
import io.crowdcode.bgav.PropertyHelper;
import io.crowdcode.bgav.XMLHandler;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import org.apache.maven.shared.utils.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.jgit.api.Git;

public class MavenHandler {
    private final Log log;
    private final boolean suppressCommit;

    public MavenHandler(boolean suppressCommit) {
        this.suppressCommit = suppressCommit;
        this.log = null;
    }

    public MavenHandler(Log log, boolean suppressCommit) {
        this.log = log;
        this.suppressCommit = suppressCommit;
    }

    public Model getModel(File pomfile) throws MojoExecutionException {
        Model model = null;
        FileReader reader = null;
        MavenXpp3Reader mavenreader = new MavenXpp3Reader();
        try {
            reader = new FileReader(pomfile);
            model = mavenreader.read((Reader)reader);
            model.setPomFile(pomfile);
        }
        catch (IOException | XmlPullParserException ex) {
            this.log.error((CharSequence)("Error: " + ex));
            throw new MojoExecutionException("could not read POM: " + ex);
        }
        return model;
    }

    public String setPomVersion(String pomVersion, String ticketID) {
        String ticketId = this.extractTicketId(pomVersion);
        this.log.info((CharSequence)("found ticketId in dependency: " + ticketId));
        if (ticketId != null && !ticketId.isEmpty()) {
            pomVersion = this.setNonBgavPomVersion(pomVersion);
            this.log.info((CharSequence)("removed wrong ticketId from POM Version: " + pomVersion));
        }
        String newPomVersion = "";
        if (pomVersion.contains(ticketID)) {
            return pomVersion;
        }
        if (pomVersion.contains("-SNAPSHOT")) {
            newPomVersion = pomVersion.substring(0, pomVersion.indexOf("-SNAPSHOT"));
            newPomVersion = newPomVersion + "-" + ticketID + "-SNAPSHOT";
        } else {
            newPomVersion = pomVersion + "-" + ticketID + "-SNAPSHOT";
        }
        this.log.info((CharSequence)("new POM Version: " + newPomVersion));
        return newPomVersion;
    }

    public String setNonBgavPomVersion(String pomVersion) {
        String newPomVersion = "";
        this.log.info((CharSequence)("non BGAV POM Version: " + pomVersion));
        if (pomVersion.contains("-SNAPSHOT")) {
            newPomVersion = pomVersion.substring(0, pomVersion.indexOf("-"));
            newPomVersion = newPomVersion + "-SNAPSHOT";
        } else {
            newPomVersion = pomVersion.indexOf("-") > 0 ? pomVersion.substring(0, pomVersion.indexOf("-")) : pomVersion;
        }
        this.log.info((CharSequence)("new non BGAV POM Version: " + newPomVersion));
        return newPomVersion;
    }

    Boolean checkForSnapshot(Model model) {
        return model.getVersion().contains("SNAPSHOT");
    }

    public String checkforDependencies(File pomfile, Model model, String[] groupIds, String ticketId, String gituser, String gitpassword, String localRepositoryPath) throws MojoExecutionException, Exception {
        if (groupIds == null) {
            this.log.info((CharSequence)"no group id(s) defined ... finished.");
            return "";
        }
        this.log.info((CharSequence)"checking dependencies for affected group id(s)...");
        DeploymentRepository deploymentRepository = model.getDistributionManagement().getSnapshotRepository();
        this.log.info((CharSequence)("using deployment repository: " + deploymentRepository + " with URL: " + deploymentRepository.getUrl()));
        List dependencyListmodel = model.getDependencies();
        String artifact = "";
        for (Dependency dependency : dependencyListmodel) {
            for (String groupid : groupIds) {
                if (!dependency.getGroupId().contains(groupid)) continue;
                String nativeVersion = dependency.getVersion();
                this.log.info((CharSequence)("affected dependency found: " + dependency + " with " + nativeVersion));
                Model dependencyModel = null;
                try {
                    dependencyModel = this.getSCMfromPOM(model, dependency, localRepositoryPath);
                }
                catch (MojoExecutionException e) {
                    this.log.warn((CharSequence)("could not get POM file: " + (Object)((Object)e)));
                    return artifact;
                }
                String dependencyScmUrl = dependencyModel.getScm().getUrl();
                String artifactId = dependency.getArtifactId();
                if (dependencyScmUrl == null || dependencyScmUrl.isEmpty()) {
                    if (!dependencyModel.getScm().getConnection().isEmpty()) {
                        this.log.info((CharSequence)"Dependency SCM entries found");
                    }
                    this.log.warn((CharSequence)("no SCM URL for affected dependency found, please add <url></url> tag to " + artifactId + "/" + nativeVersion + " POM file - skipping"));
                    continue;
                }
                this.log.info((CharSequence)("Dependency SCM URL found: " + dependencyScmUrl));
                if (!this.checkoutFromDependencyRepository(dependency, dependencyScmUrl, gituser, gitpassword, ticketId).booleanValue()) continue;
                if (!PropertyHelper.isPlaceholder(nativeVersion)) {
                    this.log.info((CharSequence)("want to change: " + nativeVersion + " -- " + ticketId));
                    String newVersion = this.setPomVersion(nativeVersion, ticketId);
                    if (nativeVersion.contains(ticketId)) {
                        this.log.info((CharSequence)"POM contains ticketId - do nothing");
                        continue;
                    }
                    dependency.setVersion(this.setPomVersion(nativeVersion, ticketId));
                    artifact = artifact + artifactId + ", ";
                    this.log.info((CharSequence)("changed dep: " + dependency));
                    new XMLHandler(this.log, this.suppressCommit).alterDependency(pomfile, artifactId, newVersion);
                    continue;
                }
                String resolvedVersion = PropertyHelper.resolveProperty(model, nativeVersion);
                this.log.info((CharSequence)("want to change placeholder: " + nativeVersion + " (" + resolvedVersion + ") -- " + ticketId));
                if (resolvedVersion.contains(ticketId)) {
                    this.log.info((CharSequence)"POM contains ticketId - do nothing");
                    continue;
                }
                String newVersion = this.setPomVersion(resolvedVersion, ticketId);
                PropertyHelper.setProperty(model, nativeVersion, newVersion);
                artifact = artifact + artifactId + ", ";
                this.log.info((CharSequence)("changed dep: " + dependency));
                new XMLHandler(this.log, this.suppressCommit).alterProperty(pomfile, PropertyHelper.unkey(nativeVersion), newVersion);
            }
        }
        return artifact;
    }

    public String removeBgavFromPom(File pomfile, Model model, String[] groupIds) {
        if (groupIds == null) {
            this.log.info((CharSequence)"no group id(s) defined ... finished.");
            return "";
        }
        this.log.info((CharSequence)"checking dependencies for affected group id(s)...");
        String artifact = "";
        List dependencyListmodel = model.getDependencies();
        for (Dependency dependency : dependencyListmodel) {
            for (String groupid : groupIds) {
                if (!dependency.getGroupId().contains(groupid)) continue;
                String version = dependency.getVersion();
                this.log.info((CharSequence)("affected dependency found: " + dependency + " with " + version));
                if (!PropertyHelper.isPlaceholder(version)) {
                    String ticketId = this.extractTicketId(version);
                    if (ticketId != null && !ticketId.isEmpty()) {
                        this.log.info((CharSequence)("dependency contains ticketId - remove it: " + ticketId));
                        String newPomDepVersion = this.setNonBgavPomVersion(version);
                        dependency.setVersion(newPomDepVersion);
                        artifact = artifact + dependency.getArtifactId() + ", ";
                        try {
                            new XMLHandler(this.log, this.suppressCommit).alterDependency(pomfile, dependency.getArtifactId(), newPomDepVersion);
                        }
                        catch (MojoExecutionException ex) {
                            this.log.warn((CharSequence)"could not write POM");
                        }
                        continue;
                    }
                    this.log.info((CharSequence)"dependency has no BGAV version");
                    continue;
                }
                String property = PropertyHelper.resolveProperty(model, version);
                String ticketId = this.extractTicketId(property);
                if (ticketId != null && !ticketId.isEmpty()) {
                    this.log.info((CharSequence)("property " + version + " contains ticketId - remove it: " + ticketId));
                    String newVersion = this.setNonBgavPomVersion(property);
                    Object dummy = PropertyHelper.setProperty(model, version, newVersion);
                    artifact = artifact + dependency.getArtifactId() + ", ";
                    try {
                        new XMLHandler(this.log, this.suppressCommit).alterProperty(pomfile, PropertyHelper.unkey(version), newVersion);
                    }
                    catch (MojoExecutionException ex) {
                        this.log.warn((CharSequence)"could not write POM");
                    }
                    continue;
                }
                this.log.info((CharSequence)"dependency has no BGAV version");
            }
        }
        return artifact;
    }

    private String extractTicketId(String version) {
        return this.getMatchFirst(version, "(\\p{Upper}{1,}-\\d{1,})");
    }

    private Model getSCMfromPOM(Model model, Dependency dependency, String localRepositoryPath) throws MojoExecutionException {
        File pomfile = new FileHelper(this.log).getPOMFilePathFromDependency(model, dependency, localRepositoryPath);
        this.log.info((CharSequence)("POM File from " + dependency.getArtifactId() + ": " + pomfile));
        return this.getModel(pomfile);
    }

    private Boolean checkoutFromDependencyRepository(Dependency dependency, String dependencyScmUrl, String gituser, String gitpassword, String ticketId) throws MojoExecutionException, IOException {
        GitHandler gitHandler = new GitHandler(this.log, gituser, gitpassword, this.suppressCommit);
        FileHelper fileHelper = new FileHelper(this.log);
        File localDirectory = fileHelper.createTempGitCheckoutDirectory(dependency.getArtifactId());
        Git gitDependency = gitHandler.cloneGitRemoteRepo(dependencyScmUrl, localDirectory);
        String[] branches = gitHandler.getBranchesFromDependency(gitDependency);
        Boolean branchFound = this.check(branches, ticketId);
        gitDependency.close();
        fileHelper.deleteTempGitCheckoutDirectory(localDirectory);
        return branchFound;
    }

    private Boolean check(String[] branches, String ticketId) throws MojoExecutionException {
        Boolean checkForTicketId = false;
        for (String branch : branches) {
            if (branch.contains(ticketId)) {
                checkForTicketId = true;
                this.log.info((CharSequence)("this is our branched version: " + branch + " for ticketID: " + ticketId));
                continue;
            }
            this.log.info((CharSequence)("branch: " + branch + " - does not match our ticket " + ticketId));
        }
        if (!checkForTicketId.booleanValue()) {
            throw new MojoExecutionException("there are no matches to our branched version");
        }
        return checkForTicketId;
    }

    private Settings getSettings() {
        this.log.info((CharSequence)"reading .m2/settings.xml for server credentials");
        Settings settings = null;
        try (Reader reader = ReaderFactory.newXmlReader((File)new File(System.getProperty("user.home") + "/.m2/settings.xml"));){
            SettingsXpp3Reader modelReader = new SettingsXpp3Reader();
            settings = modelReader.read(reader);
        }
        catch (Exception ex) {
            this.log.error((CharSequence)("could not read .m2/settings.xml: " + ex));
        }
        return settings;
    }

    String getMatchFirst(String search, String pat) {
        String match = null;
        Pattern pattern = Pattern.compile(pat);
        Matcher matcher = pattern.matcher(search);
        while (matcher.find()) {
            match = matcher.group(1);
        }
        return match;
    }
}

