/*
 * Decompiled with CFR 0.152.
 */
package io.crowdcode.bgav;

import io.crowdcode.bgav.MavenHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GitHandler {
    private String gituser;
    private String gitpassword;
    private final boolean suppressCommit;
    private final Log log;

    public GitHandler(boolean suppressCommit, Log log) {
        this.suppressCommit = suppressCommit;
        this.log = log;
    }

    public GitHandler(Log log, String gituser, String gitpassword, boolean suppressCommit) {
        this.log = log;
        this.gituser = gituser;
        this.gitpassword = gitpassword;
        this.suppressCommit = suppressCommit;
    }

    public void checkStatus(Git git) throws MojoExecutionException {
        try {
            Status status = git.status().call();
            this.log.info((CharSequence)("hasUncommittedChanges: " + status.hasUncommittedChanges()));
            Set changes = status.getModified();
            this.log.info((CharSequence)("Git changes: " + changes));
            if (changes.contains("pom.xml")) {
                throw new MojoExecutionException("POM is not commited... please commit before building application.");
            }
        }
        catch (GitAPIException | NoWorkTreeException ex) {
            this.log.error((CharSequence)("Git error: " + ex));
            throw new MojoExecutionException("Git status failed: " + ex);
        }
    }

    public Git getGitLocalRepo(Model model) throws MojoExecutionException {
        Git git = null;
        try {
            git = Git.open((File)model.getProjectDirectory());
            this.log.info((CharSequence)git.toString());
        }
        catch (RepositoryNotFoundException ex) {
            this.log.info((CharSequence)"there is no Git repo ... done.");
            return git;
        }
        catch (IOException ex) {
            throw new MojoExecutionException("could not read Git repo: " + ex);
        }
        return git;
    }

    public Git cloneGitRemoteRepo(String uri, File localDirectory) throws MojoExecutionException {
        this.log.info((CharSequence)("Git clone " + uri + " to " + localDirectory));
        Git git = null;
        try {
            UsernamePasswordCredentialsProvider cp = new UsernamePasswordCredentialsProvider(this.gituser, this.gitpassword);
            git = ((CloneCommand)Git.cloneRepository().setCredentialsProvider((CredentialsProvider)cp)).setDirectory(localDirectory).setURI(uri).call();
            this.log.info((CharSequence)git.toString());
        }
        catch (GitAPIException ex) {
            throw new MojoExecutionException("could not get Git repo: " + (Object)((Object)ex));
        }
        return git;
    }

    public String getCommitId(Git git) throws MojoExecutionException {
        String commitId;
        try {
            List refs = git.branchList().setContains("HEAD").setListMode(ListBranchCommand.ListMode.ALL).call();
            Ref ref = (Ref)refs.get(0);
            ObjectId objectId = ref.getObjectId();
            commitId = objectId == null ? "" : objectId.getName();
            this.log.info((CharSequence)("commit id: " + commitId));
        }
        catch (GitAPIException e) {
            this.log.error((CharSequence)("cannot get commit id: " + (Object)((Object)e)));
            throw new MojoExecutionException("cannot get commit id");
        }
        return commitId;
    }

    void commitAndPush(Git git, String commitMessage) throws MojoExecutionException {
        if (!this.suppressCommit) {
            try {
                UsernamePasswordCredentialsProvider cp = new UsernamePasswordCredentialsProvider(this.gituser, this.gitpassword);
                git.add().addFilepattern("pom.xml").call();
                git.commit().setMessage(commitMessage).call();
                ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)cp)).call();
            }
            catch (GitAPIException ex) {
                this.log.error((CharSequence)("GitAPIException: " + (Object)((Object)ex)));
                throw new MojoExecutionException("Git commit/push failed: " + (Object)((Object)ex));
            }
        } else {
            this.log.info((CharSequence)"Suppressing commit. Nothing is commit or pushed");
        }
    }

    public void writeChangedPOM(Model model, MavenHandler mavenHandler, String ticketID, File pomfile) throws MojoExecutionException {
        model.setVersion(mavenHandler.setPomVersion(model.getVersion(), ticketID));
        try (FileOutputStream fileOutputStream = new FileOutputStream(pomfile);){
            new MavenXpp3Writer().write((OutputStream)fileOutputStream, model);
        }
        catch (IOException ex) {
            this.log.error((CharSequence)("IOException: " + ex));
            throw new MojoExecutionException("could not write POM: " + ex);
        }
    }

    public String checkBranchName(Repository repo, String commitId, String branchName) throws MojoExecutionException {
        String branch = "";
        try {
            branch = repo.getBranch();
            if (branch == null) {
                throw new MojoExecutionException("cannot get branch");
            }
            if (branch.equals(commitId)) {
                this.log.info((CharSequence)"running on Jenkins...");
                if (branchName == null || branchName.isEmpty()) {
                    throw new MojoExecutionException("Maven parameter 'branchName' is not set");
                }
                branch = branchName;
            } else {
                branch = branchName == null || branchName.isEmpty() ? repo.getBranch() : branchName;
            }
            this.log.info((CharSequence)("Git branch: " + branch));
        }
        catch (IOException | MojoExecutionException ex) {
            this.log.error((CharSequence)("cannot get branch: " + ex));
            throw new MojoExecutionException("cannot get branch");
        }
        return branch;
    }

    public String[] getBranchesFromDependency(Git git) throws MojoExecutionException {
        String[] branches;
        try {
            List refs = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
            branches = new String[refs.size() - 1];
            for (int i = 0; i < refs.size() - 1; ++i) {
                branches[i] = ((Ref)refs.get(i)).getName();
                this.log.info((CharSequence)("found branches: " + branches[i]));
            }
        }
        catch (GitAPIException ex) {
            this.log.error((CharSequence)("cannot read branches from repositoty: " + (Object)((Object)ex)));
            throw new MojoExecutionException("cannot read branches from repositoty: " + (Object)((Object)ex));
        }
        return branches;
    }
}

