/*
 * Decompiled with CFR 0.152.
 */
package io.crowdcode.bgav;

import io.crowdcode.bgav.PropertyHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.logging.Log;

public class FileHelper {
    private final Log log;
    private final String TEMP_DIR = System.getProperty("java.io.tmpdir") + "/";
    private File localDirectory;

    public FileHelper() {
        this.log = null;
    }

    public FileHelper(Log log) {
        this.log = log;
    }

    public File getLocalDirectory() {
        return this.localDirectory;
    }

    public File getPOMFilePathFromDependency(Model model, Dependency dependency, String localRepositoryPath) {
        String nativeVersion = dependency.getVersion();
        String version = PropertyHelper.isPlaceholder(nativeVersion) ? PropertyHelper.resolveProperty(model, nativeVersion) : nativeVersion;
        return new File(localRepositoryPath + "/" + dependency.getGroupId().replaceAll("[.]", "/") + "/" + dependency.getArtifactId() + "/" + version + "/" + dependency.getArtifactId() + "-" + version + ".pom");
    }

    public File createTempGitCheckoutDirectory(String artifact) throws IOException {
        this.log.info((CharSequence)("create temp dir for checkout: " + this.TEMP_DIR + artifact));
        this.localDirectory = File.createTempFile(artifact, "git");
        this.localDirectory.delete();
        this.localDirectory.mkdir();
        return this.localDirectory;
    }

    public void deleteTempGitCheckoutDirectory(File directory) {
        this.log.info((CharSequence)("delete temp dir for checkout: " + directory));
        Path path = directory.toPath();
        try {
            Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            directory.deleteOnExit();
        }
        catch (IOException ex) {
            this.log.error((CharSequence)("could not delete local checkout direcotory: " + ex.getLocalizedMessage()));
        }
    }
}

