/*
 * Decompiled with CFR 0.152.
 */
package io.crowdcode.bgav;

import io.crowdcode.bgav.GitHandler;
import io.crowdcode.bgav.MavenHandler;
import io.crowdcode.bgav.XMLHandler;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Settings;

@Mojo(name="bgav")
public class Plugin
extends AbstractMojo {
    @Parameter(property="gituser")
    private String gituser;
    @Parameter(property="gitpassword")
    private String gitpassword;
    @Parameter(property="regex_ticket")
    private String regex_ticket;
    @Parameter(property="regex_bgav_branch")
    private String regex_bgav_branch;
    @Parameter(property="regex_non_bgav_branch")
    private String regex_not_bgav_branch;
    @Parameter(property="failOnMissingBranchId")
    private boolean failOnMissingBranchId = true;
    @Parameter(property="branchName")
    private String branchName;
    @Parameter(property="namespace")
    private String[] namespace;
    final Log log = this.getLog();
    private final String regexp = "(feature)/([A-Z0-9\\-])*-.*";
    private final String REGEX_BGAV_BRANCH = "(feature|bugfix|hotfix)";
    private final String REGEX_NON_BGAV_BRANCH = "(develop|master|release)";
    private final String REGEX_TICKET = "(\\p{Upper}{1,}-\\d{1,})";
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;

    /*
     * Unable to fully structure code
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        pomfile = new File("pom.xml");
        mavenHandler = new MavenHandler(this.log);
        model = mavenHandler.getModel(pomfile);
        this.log.info((CharSequence)("Project " + model));
        this.log.info((CharSequence)("failOnMissingBranchId: " + this.failOnMissingBranchId));
        this.log.info((CharSequence)("branchName: " + this.branchName));
        this.log.info((CharSequence)("getLocalRepository: " + this.settings.getLocalRepository()));
        if (this.gituser == null || this.gituser.isEmpty() || this.gitpassword == null || this.gitpassword.isEmpty()) {
            this.log.info((CharSequence)"no Git credentials provided");
        } else {
            this.log.info((CharSequence)"Git credentials provided");
        }
        gitHandler = new GitHandler(this.log, this.gituser, this.gitpassword);
        git = gitHandler.getGitLocalRepo(model);
        if (git == null) {
            return;
        }
        gitHandler.checkStatus(git);
        repo = git.getRepository();
        commitID = gitHandler.getCommitId(git);
        branch = gitHandler.checkBranchName(repo, commitID, this.branchName);
        ticketId = null;
        if (branch == null) {
            throw new MojoExecutionException("could not get Git branch");
        }
        if (this.checkForAllowedBgavBranch(branch).booleanValue()) {
            this.log.debug((CharSequence)"running BGAV branch");
            this.log.debug((CharSequence)("POM Version: " + model.getVersion()));
            if (this.regex_ticket == null || this.regex_ticket.isEmpty()) {
                this.log.info((CharSequence)"RegEx for ticket ID is empty, use default one: (\\p{Upper}{1,}-\\d{1,})");
                pomTicketId = this.getMatchFirst(model.getVersion(), "(\\p{Upper}{1,}-\\d{1,})");
                ticketId = this.getMatchFirst(branch, "(\\p{Upper}{1,}-\\d{1,})");
            } else {
                this.log.debug((CharSequence)("use provided RegEx for ticket ID: " + this.regex_ticket));
                pomTicketId = this.getMatchFirst(model.getVersion(), this.regex_ticket);
                ticketId = this.getMatchFirst(branch, this.regex_ticket);
            }
            this.log.debug((CharSequence)("POM ticketId: " + pomTicketId));
            this.log.debug((CharSequence)("ticketId: " + ticketId));
            if (pomTicketId == null) {
                new XMLHandler(this.log).writeChangedPomWithXPath(pomfile, ticketId);
                gitHandler.commitAndPush(git, ticketId + " - BGAV - set correct branched version");
                if (this.failOnMissingBranchId) {
                    throw new MojoExecutionException("build failed due to missing branch id and failOnMissingBranchId parameter.");
                }
                this.log.debug((CharSequence)"failOnMissingBranchId parameter is not set");
            } else if (ticketId.equals(pomTicketId)) {
                this.log.debug((CharSequence)"Git branch ticket ID matches POM ticket ID");
            } else {
                throw new MojoExecutionException("mismatch Git branch ticket ID and POM branch version ticket ID");
            }
            try {
                artifacts = mavenHandler.checkforDependencies(pomfile, model, this.namespace, ticketId, this.gituser, this.gitpassword, this.settings.getLocalRepository());
                if (artifacts.isEmpty()) ** GOTO lbl84
                gitHandler.commitAndPush(git, ticketId + " - BGAV - set correct branched version for " + (artifacts.endsWith(", ") != false ? artifacts.substring(0, artifacts.length() - 2) : artifacts));
            }
            catch (Exception ex) {
                throw new MojoExecutionException("could not check for dependencies: " + ex);
            }
        } else if (this.checkForAllowedNonBgavBranch(branch).booleanValue()) {
            this.log.debug((CharSequence)"running non BGAV branch");
            this.log.debug((CharSequence)("POM Version: " + model.getVersion()));
            if (this.regex_ticket == null || this.regex_ticket.isEmpty()) {
                this.log.debug((CharSequence)"RegEx for ticket ID is empty, use default one: (\\p{Upper}{1,}-\\d{1,})");
                ticketId = this.getMatchFirst(model.getVersion(), "(\\p{Upper}{1,}-\\d{1,})");
            } else {
                this.log.debug((CharSequence)("use provided RegEx for ticket ID: " + this.regex_ticket));
                ticketId = this.getMatchFirst(model.getVersion(), this.regex_ticket);
            }
            this.log.debug((CharSequence)("branched version found: " + ticketId));
            nonBgavVersion = mavenHandler.setNonBgavPomVersion(model.getVersion());
            if (!nonBgavVersion.equals(model.getVersion())) {
                this.log.debug((CharSequence)("none BGAV - set correct none branched version to: " + nonBgavVersion));
                new XMLHandler(this.log).writeNonBgavPomWithXPath(pomfile, nonBgavVersion);
                gitHandler.commitAndPush(git, nonBgavVersion + " - none BGAV - set correct none branched version");
                throw new MojoExecutionException("build failed due to new none branched version, new version pushed and committed.");
            }
            this.log.debug((CharSequence)"no BGAV information inside POM Version.");
            try {
                artifacts = mavenHandler.removeBgavFromPom(pomfile, model, this.namespace);
                if (!artifacts.isEmpty()) {
                    this.log.debug((CharSequence)"removed non BGAV versions from dependencies");
                    gitHandler.commitAndPush(git, "removed BGAV from " + (artifacts.endsWith(", ") != false ? artifacts.substring(0, artifacts.length() - 2) : artifacts));
                }
                this.log.debug((CharSequence)"non BGAV dependencies have to removed");
            }
            catch (MojoExecutionException ex) {
                throw new MojoExecutionException("could not check for dependencies: " + (Object)ex);
            }
        } else {
            this.log.warn((CharSequence)"no Git known branch");
            git.close();
            return;
        }
lbl84:
        // 4 sources

        git.close();
    }

    Boolean checkForAllowedBgavBranch(String branch) {
        String check = "";
        this.log.debug((CharSequence)"check for BGAV branch");
        if (this.regex_bgav_branch == null || this.regex_bgav_branch.isEmpty()) {
            this.log.debug((CharSequence)"RegEx for BGAV branch is empty, use default one: (feature|bugfix|hotfix)");
            check = this.getMatchFirst(branch, "(feature|bugfix|hotfix)");
            return check != null && !check.isEmpty();
        }
        this.log.debug((CharSequence)("use provided RegEx for BGAV branch: " + this.regex_bgav_branch));
        check = this.getMatchFirst(branch, this.regex_bgav_branch);
        return check != null && !check.isEmpty();
    }

    Boolean checkForAllowedNonBgavBranch(String branch) {
        String check = "";
        this.log.debug((CharSequence)"check for non BGAV branch");
        if (this.regex_not_bgav_branch == null || this.regex_not_bgav_branch.isEmpty()) {
            this.log.debug((CharSequence)"RegEx for non BGAV branch is empty, use default one: (develop|master|release)");
            check = this.getMatchFirst(branch, "(develop|master|release)");
            return check != null && !check.isEmpty();
        }
        this.log.info((CharSequence)("use provided RegEx for non BGAV branch: " + this.regex_not_bgav_branch));
        check = this.getMatchFirst(branch, this.regex_not_bgav_branch);
        return check != null && !check.isEmpty();
    }

    String getMatchFirst(String search, String pat) {
        String match = null;
        Pattern pattern = Pattern.compile(pat);
        Matcher matcher = pattern.matcher(search);
        while (matcher.find()) {
            match = matcher.group(1);
        }
        return match;
    }

    public Log getLogs() {
        return this.log;
    }
}

