/*
 * Decompiled with CFR 0.152.
 */
package io.cronitor.client;

import io.cronitor.client.Command;
import io.cronitor.client.CronitorPinger;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class CronitorClient {
    private Logger logger = Logger.getLogger(CronitorClient.class.getName());
    private CronitorPinger cronitorPinger = new CronitorPinger();
    private String apiKey;
    private Boolean useHttps;

    public CronitorClient() {
        this.apiKey = null;
        this.useHttps = true;
    }

    public CronitorClient(String apiKey) {
        this.apiKey = apiKey;
        this.useHttps = true;
    }

    public CronitorClient(Boolean useHttps) {
        this.useHttps = useHttps;
        this.apiKey = null;
    }

    public static CronitorClient withoutHttps() {
        return new CronitorClient(false);
    }

    public void run(String monitorKey) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)monitorKey)) {
            this.cronitorPinger.ping(Command.RUN.getValue(), monitorKey, this.apiKey, null, this.useHttps);
        } else {
            this.logger.warning("We can't ping /run on cronitor because the monitor code is null or empty");
        }
    }

    public void run(String monitorKey, String message) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)monitorKey)) {
            this.cronitorPinger.ping(Command.RUN.getValue(), monitorKey, this.apiKey, message, this.useHttps);
        } else {
            this.logger.warning("We can't ping /run on cronitor because the monitor code is null or empty");
        }
    }

    public void complete(String monitorKey) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)monitorKey)) {
            this.cronitorPinger.ping(Command.COMPLETE.getValue(), monitorKey, this.apiKey, null, this.useHttps);
        } else {
            this.logger.warning("We can't ping /complete on cronitor because the monitor code is null or empty");
        }
    }

    public void complete(String monitorKey, String message) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)monitorKey)) {
            this.cronitorPinger.ping(Command.COMPLETE.getValue(), monitorKey, this.apiKey, message, this.useHttps);
        } else {
            this.logger.warning("We can't ping /complete on cronitor because the monitor code is null or empty");
        }
    }

    public void fail(String monitorKey) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)monitorKey)) {
            this.cronitorPinger.ping(Command.FAIL.getValue(), monitorKey, this.apiKey, null, this.useHttps);
        } else {
            this.logger.warning("We can't ping /fail on cronitor because the monitor code is null or empty");
        }
    }

    public void fail(String monitorKey, String message) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)monitorKey)) {
            this.cronitorPinger.ping(Command.FAIL.getValue(), monitorKey, this.apiKey, message, this.useHttps);
        } else {
            this.logger.warning("We can't ping /fail on cronitor because the monitor code is null or empty");
        }
    }

    public void tick(String monitorKey) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)monitorKey)) {
            this.cronitorPinger.ping(Command.FAIL.getValue(), monitorKey, this.apiKey, null, this.useHttps);
        } else {
            this.logger.warning("We can't ping /fail on cronitor because the monitor code is null or empty");
        }
    }

    public void tick(String monitorKey, String message) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)monitorKey)) {
            this.cronitorPinger.ping(Command.FAIL.getValue(), monitorKey, this.apiKey, message, this.useHttps);
        } else {
            this.logger.warning("We can't ping /fail on cronitor because the monitor code is null or empty");
        }
    }

    public void pause(String monitorKey, int hours) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)this.apiKey)) {
            if (StringUtils.isNotBlank((CharSequence)monitorKey)) {
                this.cronitorPinger.pause(monitorKey, hours, this.apiKey);
            } else {
                this.logger.warning("Monitor key cannot be blank.");
            }
        } else {
            this.logger.warning("Set an API key to call pause.");
        }
    }

    public void unpause(String monitorKey) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)this.apiKey)) {
            if (StringUtils.isNotBlank((CharSequence)monitorKey)) {
                this.cronitorPinger.pause(monitorKey, 0, this.apiKey);
            } else {
                this.logger.warning("Monitor key cannot be blank.");
            }
        } else {
            this.logger.warning("Set an API key to call unpause.");
        }
    }
}

