/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.util.schedule;

import io.craft.atom.util.schedule.ExpirationListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimingWheel<E> {
    private static final Logger LOG = LoggerFactory.getLogger(TimingWheel.class);
    private final long tickDuration;
    private final int ticksPerWheel;
    private final ArrayList<Slot<E>> wheel;
    private final Map<E, Slot<E>> indicator = new ConcurrentHashMap<E, Slot<E>>();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final CopyOnWriteArrayList<ExpirationListener<E>> expirationListeners = new CopyOnWriteArrayList();
    private volatile int currentTickIndex = 0;
    private Thread workerThread;

    public TimingWheel(int tickDuration, int ticksPerWheel, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        if (tickDuration <= 0) {
            throw new IllegalArgumentException("tickDuration must be greater than 0: " + tickDuration);
        }
        if (ticksPerWheel <= 0) {
            throw new IllegalArgumentException("ticksPerWheel must be greater than 0: " + ticksPerWheel);
        }
        this.wheel = new ArrayList();
        this.tickDuration = TimeUnit.MILLISECONDS.convert(tickDuration, timeUnit);
        this.ticksPerWheel = ticksPerWheel + 1;
        for (int i = 0; i < this.ticksPerWheel; ++i) {
            this.wheel.add(new Slot(i));
        }
        this.wheel.trimToSize();
        this.workerThread = new Thread((Runnable)new TickWorker(), "Timing-Wheel");
    }

    public void start() {
        if (this.shutdown.get()) {
            throw new IllegalStateException("Cannot be started once stopped");
        }
        if (!this.workerThread.isAlive()) {
            this.workerThread.start();
        }
    }

    public boolean stop() {
        if (!this.shutdown.compareAndSet(false, true)) {
            return false;
        }
        boolean interrupted = false;
        while (this.workerThread.isAlive()) {
            this.workerThread.interrupt();
            try {
                this.workerThread.join(100L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return true;
    }

    public void addExpirationListener(ExpirationListener<E> listener) {
        this.expirationListeners.add(listener);
    }

    public void removeExpirationListener(ExpirationListener<E> listener) {
        this.expirationListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long add(E e) {
        E e2 = e;
        synchronized (e2) {
            this.checkAdd(e);
            int previousTickIndex = this.getPreviousTickIndex();
            Slot<E> slot = this.wheel.get(previousTickIndex);
            slot.add(e);
            this.indicator.put(e, slot);
            return (long)(this.ticksPerWheel - 1) * this.tickDuration;
        }
    }

    private void checkAdd(E e) {
        Slot<E> slot = this.indicator.get(e);
        if (slot != null) {
            slot.remove(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPreviousTickIndex() {
        this.lock.readLock().lock();
        try {
            int cti = this.currentTickIndex;
            if (cti == 0) {
                int n = this.ticksPerWheel - 1;
                return n;
            }
            int n = cti - 1;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(E e) {
        E e2 = e;
        synchronized (e2) {
            Slot<E> slot = this.indicator.get(e);
            if (slot == null) {
                return false;
            }
            this.indicator.remove(e);
            return slot.remove(e) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyExpired(int idx) {
        Slot<E> slot = this.wheel.get(idx);
        Set<E> elements = slot.elements();
        for (E e : elements) {
            slot.remove(e);
            E e2 = e;
            synchronized (e2) {
                Slot<E> latestSlot = this.indicator.get(e);
                if (slot.equals(latestSlot)) {
                    this.indicator.remove(e);
                }
            }
            for (ExpirationListener<E> listener : this.expirationListeners) {
                listener.expired(e);
            }
        }
    }

    public int size() {
        return this.indicator.size();
    }

    public Set<E> elements() {
        return this.indicator.keySet();
    }

    public String toString() {
        return "TimingWheel(tickDuration=" + this.tickDuration + ", ticksPerWheel=" + this.ticksPerWheel + ", wheel=" + this.wheel + ", indicator=" + this.indicator + ", currentTickIndex=" + this.currentTickIndex + ")";
    }

    private static class Slot<E> {
        private int id;
        private Map<E, E> elements = new ConcurrentHashMap<E, E>();

        public Slot(int id) {
            this.id = id;
        }

        public void add(E e) {
            this.elements.put(e, e);
        }

        public E remove(E e) {
            return this.elements.remove(e);
        }

        public Set<E> elements() {
            return this.elements.keySet();
        }

        public String toString() {
            return "TimingWheel.Slot(id=" + this.id + ", elements=" + this.elements + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Slot)) {
                return false;
            }
            Slot other = (Slot)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.id == other.id;
        }

        public boolean canEqual(Object other) {
            return other instanceof Slot;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = result * 31 + this.id;
            return result;
        }
    }

    private class TickWorker
    implements Runnable {
        private long startTime;
        private long tick;

        private TickWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.startTime = System.currentTimeMillis();
            this.tick = 1L;
            int i = 0;
            while (!TimingWheel.this.shutdown.get()) {
                if (i == TimingWheel.this.wheel.size()) {
                    i = 0;
                }
                TimingWheel.this.lock.writeLock().lock();
                try {
                    TimingWheel.this.currentTickIndex = i;
                }
                finally {
                    TimingWheel.this.lock.writeLock().unlock();
                }
                TimingWheel.this.notifyExpired(TimingWheel.this.currentTickIndex);
                this.waitForNextTick();
                ++i;
            }
        }

        private void waitForNextTick() {
            while (true) {
                long currentTime = System.currentTimeMillis();
                long sleepTime = TimingWheel.this.tickDuration * this.tick - (currentTime - this.startTime);
                LOG.debug("[CRAFT-ATOM-UTIL] Wait for next tick sleep |sleepTime={}|", (Object)sleepTime);
                if (sleepTime <= 0L) break;
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            ++this.tick;
        }
    }
}

