/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.util.buffer;

import io.craft.atom.util.buffer.BufferAllocator;
import io.craft.atom.util.buffer.SimpleBufferAllocator;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.EnumSet;
import java.util.Set;

public abstract class AdaptiveByteBuffer
implements Comparable<AdaptiveByteBuffer> {
    private static BufferAllocator allocator = new SimpleBufferAllocator();
    private static boolean useDirectBuffer = false;

    public static BufferAllocator getAllocator() {
        return allocator;
    }

    public static void setAllocator(BufferAllocator newAllocator) {
        if (newAllocator == null) {
            throw new IllegalArgumentException("allocator");
        }
        BufferAllocator oldAllocator = allocator;
        allocator = newAllocator;
        if (null != oldAllocator) {
            oldAllocator.dispose();
        }
    }

    public static boolean isUseDirectBuffer() {
        return useDirectBuffer;
    }

    public static void setUseDirectBuffer(boolean useDirectBuffer) {
        AdaptiveByteBuffer.useDirectBuffer = useDirectBuffer;
    }

    public static AdaptiveByteBuffer allocate(int capacity) {
        return AdaptiveByteBuffer.allocate(capacity, useDirectBuffer);
    }

    public static AdaptiveByteBuffer allocate(int capacity, boolean direct) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity: " + capacity);
        }
        return allocator.allocate(capacity, direct);
    }

    public static AdaptiveByteBuffer wrap(ByteBuffer nioBuffer) {
        return allocator.wrap(nioBuffer);
    }

    public static AdaptiveByteBuffer wrap(byte[] byteArray) {
        return AdaptiveByteBuffer.wrap(ByteBuffer.wrap(byteArray));
    }

    public static AdaptiveByteBuffer wrap(byte[] byteArray, int offset, int length) {
        return AdaptiveByteBuffer.wrap(ByteBuffer.wrap(byteArray, offset, length));
    }

    protected static int normalizeCapacity(int requestedCapacity) {
        int newCapacity;
        if (requestedCapacity < 0) {
            return Integer.MAX_VALUE;
        }
        return (newCapacity <<= (newCapacity = Integer.highestOneBit(requestedCapacity)) < requestedCapacity ? 1 : 0) < 0 ? Integer.MAX_VALUE : newCapacity;
    }

    protected AdaptiveByteBuffer() {
    }

    public abstract void free();

    public abstract ByteBuffer buf();

    public abstract boolean isDirect();

    public abstract boolean isDerived();

    public abstract boolean isReadOnly();

    public abstract int minimumCapacity();

    public abstract AdaptiveByteBuffer minimumCapacity(int var1);

    public abstract int capacity();

    public abstract AdaptiveByteBuffer capacity(int var1);

    public abstract boolean isAutoExpand();

    public abstract AdaptiveByteBuffer setAutoExpand(boolean var1);

    public abstract boolean isAutoShrink();

    public abstract AdaptiveByteBuffer setAutoShrink(boolean var1);

    public abstract AdaptiveByteBuffer expand(int var1);

    public abstract AdaptiveByteBuffer expand(int var1, int var2);

    public abstract AdaptiveByteBuffer shrink();

    public abstract int position();

    public abstract AdaptiveByteBuffer position(int var1);

    public abstract int limit();

    public abstract AdaptiveByteBuffer limit(int var1);

    public abstract AdaptiveByteBuffer mark();

    public abstract int markValue();

    public abstract AdaptiveByteBuffer reset();

    public abstract AdaptiveByteBuffer clear();

    public abstract AdaptiveByteBuffer sweep();

    public abstract AdaptiveByteBuffer sweep(byte var1);

    public abstract AdaptiveByteBuffer flip();

    public abstract AdaptiveByteBuffer rewind();

    public abstract int remaining();

    public abstract boolean hasRemaining();

    public abstract AdaptiveByteBuffer duplicate();

    public abstract AdaptiveByteBuffer slice();

    public abstract AdaptiveByteBuffer asReadOnlyBuffer();

    public abstract boolean hasArray();

    public abstract byte[] array();

    public abstract int arrayOffset();

    public abstract byte get();

    public abstract short getUnsigned();

    public abstract AdaptiveByteBuffer put(byte var1);

    public abstract byte get(int var1);

    public abstract short getUnsigned(int var1);

    public abstract AdaptiveByteBuffer put(int var1, byte var2);

    public abstract AdaptiveByteBuffer get(byte[] var1, int var2, int var3);

    public abstract AdaptiveByteBuffer get(byte[] var1);

    public abstract AdaptiveByteBuffer getSlice(int var1, int var2);

    public abstract AdaptiveByteBuffer getSlice(int var1);

    public abstract AdaptiveByteBuffer put(ByteBuffer var1);

    public abstract AdaptiveByteBuffer put(AdaptiveByteBuffer var1);

    public abstract AdaptiveByteBuffer put(byte[] var1, int var2, int var3);

    public abstract AdaptiveByteBuffer put(byte[] var1);

    public abstract AdaptiveByteBuffer compact();

    public abstract ByteOrder order();

    public abstract AdaptiveByteBuffer order(ByteOrder var1);

    public abstract char getChar();

    public abstract AdaptiveByteBuffer putChar(char var1);

    public abstract char getChar(int var1);

    public abstract AdaptiveByteBuffer putChar(int var1, char var2);

    public abstract CharBuffer asCharBuffer();

    public abstract short getShort();

    public abstract int getUnsignedShort();

    public abstract AdaptiveByteBuffer putShort(short var1);

    public abstract short getShort(int var1);

    public abstract int getUnsignedShort(int var1);

    public abstract AdaptiveByteBuffer putShort(int var1, short var2);

    public abstract ShortBuffer asShortBuffer();

    public abstract int getInt();

    public abstract long getUnsignedInt();

    public abstract int getMediumInt();

    public abstract int getUnsignedMediumInt();

    public abstract int getMediumInt(int var1);

    public abstract int getUnsignedMediumInt(int var1);

    public abstract AdaptiveByteBuffer putMediumInt(int var1);

    public abstract AdaptiveByteBuffer putMediumInt(int var1, int var2);

    public abstract AdaptiveByteBuffer putInt(int var1);

    public abstract AdaptiveByteBuffer putUnsigned(byte var1);

    public abstract AdaptiveByteBuffer putUnsigned(int var1, byte var2);

    public abstract AdaptiveByteBuffer putUnsigned(short var1);

    public abstract AdaptiveByteBuffer putUnsigned(int var1, short var2);

    public abstract AdaptiveByteBuffer putUnsigned(int var1);

    public abstract AdaptiveByteBuffer putUnsigned(int var1, int var2);

    public abstract AdaptiveByteBuffer putUnsigned(long var1);

    public abstract AdaptiveByteBuffer putUnsigned(int var1, long var2);

    public abstract AdaptiveByteBuffer putUnsignedInt(byte var1);

    public abstract AdaptiveByteBuffer putUnsignedInt(int var1, byte var2);

    public abstract AdaptiveByteBuffer putUnsignedInt(short var1);

    public abstract AdaptiveByteBuffer putUnsignedInt(int var1, short var2);

    public abstract AdaptiveByteBuffer putUnsignedInt(int var1);

    public abstract AdaptiveByteBuffer putUnsignedInt(int var1, int var2);

    public abstract AdaptiveByteBuffer putUnsignedInt(long var1);

    public abstract AdaptiveByteBuffer putUnsignedInt(int var1, long var2);

    public abstract AdaptiveByteBuffer putUnsignedShort(byte var1);

    public abstract AdaptiveByteBuffer putUnsignedShort(int var1, byte var2);

    public abstract AdaptiveByteBuffer putUnsignedShort(short var1);

    public abstract AdaptiveByteBuffer putUnsignedShort(int var1, short var2);

    public abstract AdaptiveByteBuffer putUnsignedShort(int var1);

    public abstract AdaptiveByteBuffer putUnsignedShort(int var1, int var2);

    public abstract AdaptiveByteBuffer putUnsignedShort(long var1);

    public abstract AdaptiveByteBuffer putUnsignedShort(int var1, long var2);

    public abstract int getInt(int var1);

    public abstract long getUnsignedInt(int var1);

    public abstract AdaptiveByteBuffer putInt(int var1, int var2);

    public abstract IntBuffer asIntBuffer();

    public abstract long getLong();

    public abstract AdaptiveByteBuffer putLong(long var1);

    public abstract long getLong(int var1);

    public abstract AdaptiveByteBuffer putLong(int var1, long var2);

    public abstract LongBuffer asLongBuffer();

    public abstract float getFloat();

    public abstract AdaptiveByteBuffer putFloat(float var1);

    public abstract float getFloat(int var1);

    public abstract AdaptiveByteBuffer putFloat(int var1, float var2);

    public abstract FloatBuffer asFloatBuffer();

    public abstract double getDouble();

    public abstract AdaptiveByteBuffer putDouble(double var1);

    public abstract double getDouble(int var1);

    public abstract AdaptiveByteBuffer putDouble(int var1, double var2);

    public abstract DoubleBuffer asDoubleBuffer();

    public abstract InputStream asInputStream();

    public abstract OutputStream asOutputStream();

    public abstract String getHexDump();

    public abstract String getHexDump(int var1);

    public abstract String getString(CharsetDecoder var1) throws CharacterCodingException;

    public abstract String getString(int var1, CharsetDecoder var2) throws CharacterCodingException;

    public abstract AdaptiveByteBuffer putString(CharSequence var1, CharsetEncoder var2) throws CharacterCodingException;

    public abstract AdaptiveByteBuffer putString(CharSequence var1, int var2, CharsetEncoder var3) throws CharacterCodingException;

    public abstract String getPrefixedString(CharsetDecoder var1) throws CharacterCodingException;

    public abstract String getPrefixedString(int var1, CharsetDecoder var2) throws CharacterCodingException;

    public abstract AdaptiveByteBuffer putPrefixedString(CharSequence var1, CharsetEncoder var2) throws CharacterCodingException;

    public abstract AdaptiveByteBuffer putPrefixedString(CharSequence var1, int var2, CharsetEncoder var3) throws CharacterCodingException;

    public abstract AdaptiveByteBuffer putPrefixedString(CharSequence var1, int var2, int var3, CharsetEncoder var4) throws CharacterCodingException;

    public abstract AdaptiveByteBuffer putPrefixedString(CharSequence var1, int var2, int var3, byte var4, CharsetEncoder var5) throws CharacterCodingException;

    public abstract Object getObject() throws ClassNotFoundException;

    public abstract Object getObject(ClassLoader var1) throws ClassNotFoundException;

    public abstract AdaptiveByteBuffer putObject(Object var1);

    public abstract boolean prefixedDataAvailable(int var1);

    public abstract boolean prefixedDataAvailable(int var1, int var2);

    public abstract int indexOf(byte var1);

    public abstract AdaptiveByteBuffer skip(int var1);

    public abstract AdaptiveByteBuffer fill(byte var1, int var2);

    public abstract AdaptiveByteBuffer fillAndReset(byte var1, int var2);

    public abstract AdaptiveByteBuffer fill(int var1);

    public abstract AdaptiveByteBuffer fillAndReset(int var1);

    public abstract <E extends Enum<E>> E getEnum(Class<E> var1);

    public abstract <E extends Enum<E>> E getEnum(int var1, Class<E> var2);

    public abstract <E extends Enum<E>> E getEnumShort(Class<E> var1);

    public abstract <E extends Enum<E>> E getEnumShort(int var1, Class<E> var2);

    public abstract <E extends Enum<E>> E getEnumInt(Class<E> var1);

    public abstract <E extends Enum<E>> E getEnumInt(int var1, Class<E> var2);

    public abstract AdaptiveByteBuffer putEnum(Enum<?> var1);

    public abstract AdaptiveByteBuffer putEnum(int var1, Enum<?> var2);

    public abstract AdaptiveByteBuffer putEnumShort(Enum<?> var1);

    public abstract AdaptiveByteBuffer putEnumShort(int var1, Enum<?> var2);

    public abstract AdaptiveByteBuffer putEnumInt(Enum<?> var1);

    public abstract AdaptiveByteBuffer putEnumInt(int var1, Enum<?> var2);

    public abstract <E extends Enum<E>> EnumSet<E> getEnumSet(Class<E> var1);

    public abstract <E extends Enum<E>> EnumSet<E> getEnumSet(int var1, Class<E> var2);

    public abstract <E extends Enum<E>> EnumSet<E> getEnumSetShort(Class<E> var1);

    public abstract <E extends Enum<E>> EnumSet<E> getEnumSetShort(int var1, Class<E> var2);

    public abstract <E extends Enum<E>> EnumSet<E> getEnumSetInt(Class<E> var1);

    public abstract <E extends Enum<E>> EnumSet<E> getEnumSetInt(int var1, Class<E> var2);

    public abstract <E extends Enum<E>> EnumSet<E> getEnumSetLong(Class<E> var1);

    public abstract <E extends Enum<E>> EnumSet<E> getEnumSetLong(int var1, Class<E> var2);

    public abstract <E extends Enum<E>> AdaptiveByteBuffer putEnumSet(Set<E> var1);

    public abstract <E extends Enum<E>> AdaptiveByteBuffer putEnumSet(int var1, Set<E> var2);

    public abstract <E extends Enum<E>> AdaptiveByteBuffer putEnumSetShort(Set<E> var1);

    public abstract <E extends Enum<E>> AdaptiveByteBuffer putEnumSetShort(int var1, Set<E> var2);

    public abstract <E extends Enum<E>> AdaptiveByteBuffer putEnumSetInt(Set<E> var1);

    public abstract <E extends Enum<E>> AdaptiveByteBuffer putEnumSetInt(int var1, Set<E> var2);

    public abstract <E extends Enum<E>> AdaptiveByteBuffer putEnumSetLong(Set<E> var1);

    public abstract <E extends Enum<E>> AdaptiveByteBuffer putEnumSetLong(int var1, Set<E> var2);
}

