/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.util;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.Random;

public class StringUtil {
    public static String dbc2sbcCase(String src) {
        if (src == null) {
            return null;
        }
        char[] c = src.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String sbc2dbcCase(String src) {
        if (src == null) {
            return null;
        }
        char[] c = src.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static String toString(String[] array, String delim) {
        if (array == null) {
            return null;
        }
        int length = array.length - 1;
        if (delim == null) {
            delim = "";
        }
        StringBuilder buf = new StringBuilder(length * 8);
        for (int i = 0; i < length; ++i) {
            buf.append(array[i]);
            buf.append(delim);
        }
        buf.append(array[length]);
        return buf.toString();
    }

    public static boolean contains(String[] strings, String string, boolean caseSensitive) {
        if (strings == null || strings.length == 0) {
            return false;
        }
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < strings.length; ++i) {
            if (!(caseSensitive ? strings[i].equals(string) : strings[i].equalsIgnoreCase(string))) continue;
            return true;
        }
        return false;
    }

    public static boolean containSubstring(String[] strings, String string, boolean caseSensitive) {
        if (strings == null || strings.length == 0) {
            return false;
        }
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < strings.length; ++i) {
            if (!(caseSensitive ? strings[i].equals(string) || strings[i].indexOf(string) > -1 : strings[i].equalsIgnoreCase(string) || strings[i].toLowerCase().indexOf(string.toLowerCase()) > -1)) continue;
            return true;
        }
        return false;
    }

    public static int count(String src, String target) {
        int count = 0;
        int index = src.indexOf(target);
        while (index != -1) {
            ++count;
            index = src.indexOf(target, index + 1);
        }
        return count;
    }

    public static String firstCharToLowerCase(String src) {
        if (src.length() == 1) {
            return src.substring(0, 1).toLowerCase();
        }
        return src.substring(0, 1).toLowerCase() + src.substring(1);
    }

    public static String firstCharToUpperCase(String src) {
        if (src.length() == 1) {
            return src.substring(0, 1).toUpperCase();
        }
        return src.substring(0, 1).toUpperCase() + src.substring(1);
    }

    public static String toCurrencyString(String src, Locale locale) {
        Double currency = Double.parseDouble(src);
        return StringUtil.toCurrencyString(currency, locale);
    }

    public static String toCurrencyString(Double src, Locale locale) {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        NumberFormat nf = NumberFormat.getCurrencyInstance(locale);
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        return nf.format(src);
    }

    public static String replace(String prefix, String src, String value) {
        String[] values = new String[]{value};
        return StringUtil.replace(prefix, src, values);
    }

    public static String getReplaceString(String src, String[] values) {
        return StringUtil.replace("%", src, values);
    }

    public static String replace(String prefix, String src, String[] values) {
        if (src == null || values == null || values.length < 1) {
            return src;
        }
        if (prefix == null) {
            prefix = "%";
        }
        StringBuilder result = new StringBuilder();
        int beginIndex = 0;
        int i = 0;
        int count = 0;
        while (true) {
            String argument = prefix + Integer.toString(i + 1);
            int endIndex = src.indexOf(argument, beginIndex);
            ++count;
            if (endIndex == -1) break;
            int len = Integer.valueOf(count).toString().length() + 1;
            StringBuilder part = new StringBuilder(src.substring(beginIndex, endIndex));
            if (i < values.length) {
                part.append(values[i]);
            } else {
                part.append(values[values.length - 1]);
            }
            result.append((CharSequence)part);
            beginIndex = endIndex + len;
            ++i;
        }
        result.append(src.substring(beginIndex));
        return result.toString();
    }

    public static String insert(String src, String target, int index) {
        if (src == null) {
            return src;
        }
        if (index < 0 || index > src.length()) {
            return src;
        }
        StringBuilder sb = new StringBuilder();
        if (index != 0) {
            sb.append(src.substring(0, index));
        }
        sb.append(target);
        sb.append(src.substring(index));
        return sb.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyEmpty(String ... strings) {
        if (strings == null) {
            return true;
        }
        for (String s : strings) {
            if (!StringUtil.isEmpty(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyBlank(String ... strings) {
        if (strings == null) {
            return true;
        }
        for (String s : strings) {
            if (!StringUtil.isBlank(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(String ... strings) {
        if (strings == null) {
            return true;
        }
        boolean b = true;
        for (String s : strings) {
            b &= StringUtil.isEmpty(s);
        }
        return b;
    }

    public static boolean isAllBlank(String ... strings) {
        if (strings == null) {
            return true;
        }
        boolean b = true;
        for (String s : strings) {
            b &= StringUtil.isBlank(s);
        }
        return b;
    }

    public static boolean isAllNotBlank(String ... strings) {
        return !StringUtil.isAnyBlank(strings);
    }

    public static boolean isAllNotEmpty(String ... strings) {
        return !StringUtil.isAnyEmpty(strings);
    }

    public static boolean isDigitalString(String src) {
        if (src == null) {
            return false;
        }
        for (int i = 0; i < src.length(); ++i) {
            if (Character.isDigit(src.charAt(i)) || src.charAt(i) == '.') continue;
            return false;
        }
        return true;
    }

    public static boolean hasLength(CharSequence src) {
        return src != null && src.length() > 0;
    }

    public static boolean hasText(CharSequence str) {
        if (!StringUtil.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String trimAll(String src) {
        if (!StringUtil.hasLength(src)) {
            return src;
        }
        StringBuilder sb = new StringBuilder(src);
        int index = 0;
        while (sb.length() > index) {
            if (Character.isWhitespace(sb.charAt(index))) {
                sb.deleteCharAt(index);
                continue;
            }
            ++index;
        }
        return sb.toString();
    }

    public static String trimLeading(String str) {
        if (!StringUtil.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailing(String str) {
        if (!StringUtil.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String[] split(String str, int num) {
        if (str == null) {
            return null;
        }
        if (num <= 1) {
            return new String[]{str};
        }
        String[] sarr = null;
        int len = str.length();
        if (num >= len) {
            sarr = new String[len];
            for (int i = 0; i < len; ++i) {
                sarr[i] = Character.toString(str.charAt(i));
            }
            return sarr;
        }
        Random ran = new Random();
        int scope = len / num;
        int start = 0;
        int end = 0;
        sarr = new String[num];
        for (int i = 0; i < num; ++i) {
            if (i == num - 1) {
                sarr[i] = str.substring(start);
                continue;
            }
            end = ran.nextInt(scope) + start;
            sarr[i] = str.substring(start, end);
            start = end;
        }
        return sarr;
    }

    private StringUtil() {
        throw new UnsupportedOperationException();
    }
}

