/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.Enumeration;

public class NetUtil {
    public static InetAddress getIpv4Address() throws IOException {
        return NetUtil.getIpv4Address(null);
    }

    public static InetAddress getIpv4Address(String prefix) throws IOException {
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        InetAddress addr = null;
        boolean found = false;
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            while (addrs.hasMoreElements()) {
                addr = addrs.nextElement();
                if (!addr.isLoopbackAddress() && addr.getHostAddress().indexOf(":") == -1) {
                    if (prefix == null) {
                        found = true;
                        break;
                    }
                    if (prefix == null || !addr.getHostAddress().startsWith(prefix)) continue;
                    found = true;
                    break;
                }
                addr = null;
            }
            if (!found) continue;
            break;
        }
        if (addr == null) {
            addr = InetAddress.getLocalHost();
        }
        return addr;
    }

    public static boolean isLocalPortUsing(int port) {
        return NetUtil.isPortUsing("127.0.0.1", port);
    }

    public static boolean isPortUsing(String host, int port) {
        try {
            new Socket(host, port);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private NetUtil() {
    }
}

