/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtil {
    private static final int BUFFER_SIZE = 16384;

    private FileUtil() {
        throw new UnsupportedOperationException();
    }

    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        int bytesRead = inputStream.read(buffer);
        while (bytesRead != -1) {
            outputStream.write(buffer, 0, bytesRead);
            bytesRead = inputStream.read(buffer);
        }
        return outputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(String filePath) throws IOException {
        byte[] buffer = new byte[(int)FileUtil.getFile(filePath).length()];
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(FileUtil.getFile(filePath)));
            bis.read(buffer);
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
        return new String(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(String content, String filePath) throws Exception {
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(FileUtil.getFile(filePath)));
            bos.write(content.getBytes());
            ((BufferedOutputStream)bos).flush();
        }
        finally {
            if (bos != null) {
                bos.close();
            }
        }
    }

    public static File getFile(String filePath) throws IOException {
        return new File(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dst) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(src), 16384);
            out = new BufferedOutputStream(new FileOutputStream(dst), 16384);
            byte[] buffer = new byte[16384];
            while (in.read(buffer) > 0) {
                out.write(buffer);
            }
        }
        finally {
            if (null != in) {
                in.close();
            }
            if (null != out) {
                out.close();
            }
        }
    }

    public static String suffix(File file) {
        String name = file.getName();
        int pos = name.lastIndexOf(".");
        return name.substring(pos);
    }

    public static String suffix(String fileName) {
        int pos = fileName.lastIndexOf(".");
        return fileName.substring(pos);
    }

    public static boolean delete(String filePath) throws IOException {
        File file = FileUtil.getFile(filePath);
        return file.delete();
    }
}

