/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.util;

public class ByteUtil {
    public static int indexOf(byte[] source, byte[] target) {
        if (source == null || target == null) {
            return -1;
        }
        if (target.length == 1) {
            return ByteUtil.indexOf(source, target[0]);
        }
        return ByteUtil.indexOf(source, 0, source.length, target, 0, target.length, 0);
    }

    public static int indexOf(byte[] source, byte[] target, int fromIndex) {
        if (source == null || target == null) {
            return -1;
        }
        if (target.length == 1) {
            return ByteUtil.indexOf(source, target[0], fromIndex);
        }
        return ByteUtil.indexOf(source, 0, source.length, target, 0, target.length, fromIndex);
    }

    public static int indexOf(byte[] source, byte[] target, int fromIndex, int endIndex) {
        if (source == null || target == null || fromIndex >= endIndex) {
            return -1;
        }
        if (target.length == 1) {
            return ByteUtil.indexOf(source, target[0], fromIndex, endIndex);
        }
        int sourceCount = endIndex - fromIndex;
        return ByteUtil.indexOf(source, 0, sourceCount, target, 0, target.length, fromIndex);
    }

    public static int indexOf(byte[] source, byte target) {
        if (source == null || source.length == 0) {
            return -1;
        }
        for (int i = 0; i < source.length; ++i) {
            if (source[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] source, byte target, int fromIndex) {
        if (source == null || source.length == 0 || fromIndex >= source.length) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        for (int i = fromIndex; i < source.length; ++i) {
            if (source[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] source, byte target, int fromIndex, int endIndex) {
        if (source == null || source.length == 0 || fromIndex >= endIndex) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > source.length) {
            endIndex = source.length;
        }
        for (int i = fromIndex; i < endIndex; ++i) {
            if (source[i] != target) continue;
            return i;
        }
        return -1;
    }

    private static int indexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public static byte[] split(byte[] bytes, int start, int end) {
        if (bytes == null) {
            return null;
        }
        if (start < 0) {
            throw new IllegalArgumentException("start < 0");
        }
        if (end > bytes.length) {
            throw new IllegalArgumentException("end > size");
        }
        if (start > end) {
            throw new IllegalArgumentException("start > end");
        }
        int len = end - start;
        byte[] dest = new byte[len];
        System.arraycopy(bytes, start, dest, 0, len);
        return dest;
    }

    public static byte[] reverse(byte[] src) {
        if (src == null) {
            return null;
        }
        byte[] dst = new byte[src.length];
        int j = 0;
        for (int i = src.length - 1; i >= 0; --i) {
            dst[j] = src[i];
            ++j;
        }
        return dst;
    }

    public static String asHex(byte[] bytes) {
        return ByteUtil.asHex(bytes, null);
    }

    public static String asHex(byte[] bytes, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String code = Integer.toHexString(bytes[i] & 0xFF);
            if ((bytes[i] & 0xFF) < 16) {
                sb.append('0');
            }
            sb.append(code);
            if (separator == null || i >= bytes.length - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static byte[] intToNetworkByteOrder(int num, int count) {
        byte[] buf = new byte[count];
        ByteUtil.intToNetworkByteOrder(num, buf, 0, count);
        return buf;
    }

    private static void intToNetworkByteOrder(int num, byte[] buf, int start, int count) {
        if (count > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        for (int i = count - 1; i >= 0; --i) {
            buf[start + i] = (byte)(num & 0xFF);
            num >>>= 8;
        }
    }

    public static int networkByteOrderToInt(byte[] buf) {
        return ByteUtil.networkByteOrderToInt(buf, 0, buf.length);
    }

    public static int networkByteOrderToInt(byte[] buf, int start, int count) {
        if (count > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        int result = 0;
        for (int i = 0; i < count; ++i) {
            result <<= 8;
            result |= buf[start + i] & 0xFF;
        }
        return result;
    }

    public static boolean isEmpty(byte[] bytes) {
        return bytes == null || bytes.length == 0;
    }

    public static final short bytes2short(byte[] b) {
        return ByteUtil.bytes2short(b, 0);
    }

    public static final short bytes2short(byte[] b, int off) {
        return (short)((b[off] & 0xFF) << 8 | b[off + 1] & 0xFF);
    }

    public static final byte[] short2bytes(short s) {
        byte[] b = new byte[]{0, 0};
        ByteUtil.short2bytes(s, b, 0);
        return b;
    }

    public static void short2bytes(short s, byte[] b, int off) {
        b[off + 1] = (byte)s;
        b[off + 0] = (byte)(s >>> 8);
    }

    public static final int bytes2int(byte[] b) {
        return ByteUtil.bytes2int(b, 0);
    }

    public static final int bytes2int(byte[] b, int off) {
        return b[off] << 24 | (b[off + 1] & 0xFF) << 16 | (b[off + 2] & 0xFF) << 8 | b[off + 3] & 0xFF;
    }

    public static final byte[] int2bytes(int i) {
        byte[] b = new byte[]{0, 0, 0, 0};
        ByteUtil.int2bytes(i, b, 0);
        return b;
    }

    public static void int2bytes(int i, byte[] b, int off) {
        b[off + 3] = (byte)i;
        b[off + 2] = (byte)(i >>> 8);
        b[off + 1] = (byte)(i >>> 16);
        b[off + 0] = (byte)(i >>> 24);
    }

    public static final long bytes2long(byte[] b) {
        return ByteUtil.bytes2long(b, 0);
    }

    public static final long bytes2long(byte[] b, int off) {
        return (long)b[off] << 56 | (long)(b[off + 1] & 0xFF) << 48 | ((long)b[off + 2] & 0xFFL) << 40 | ((long)b[off + 3] & 0xFFL) << 32 | ((long)b[off + 4] & 0xFFL) << 24 | ((long)b[off + 5] & 0xFFL) << 16 | ((long)b[off + 6] & 0xFFL) << 8 | (long)b[off + 7] & 0xFFL;
    }

    public static final byte[] long2bytes(long l) {
        byte[] b = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        ByteUtil.long2bytes(l, b, 0);
        return b;
    }

    public static void long2bytes(long l, byte[] b, int off) {
        b[off + 7] = (byte)l;
        b[off + 6] = (byte)(l >>> 8);
        b[off + 5] = (byte)(l >>> 16);
        b[off + 4] = (byte)(l >>> 24);
        b[off + 3] = (byte)(l >>> 32);
        b[off + 2] = (byte)(l >>> 40);
        b[off + 1] = (byte)(l >>> 48);
        b[off + 0] = (byte)(l >>> 56);
    }

    public static float bytes2float(byte[] b) {
        return ByteUtil.bytes2float(b, 0);
    }

    public static float bytes2float(byte[] b, int off) {
        int i = b[off] << 24 | (b[off + 1] & 0xFF) << 16 | (b[off + 2] & 0xFF) << 8 | b[off + 3] & 0xFF;
        return Float.intBitsToFloat(i);
    }

    public static final byte[] float2bytes(float f) {
        byte[] b = new byte[]{0, 0, 0, 0};
        ByteUtil.float2bytes(f, b, 0);
        return b;
    }

    public static void float2bytes(float f, byte[] b, int off) {
        int i = Float.floatToIntBits(f);
        b[off + 3] = (byte)i;
        b[off + 2] = (byte)(i >>> 8);
        b[off + 1] = (byte)(i >>> 16);
        b[off + 0] = (byte)(i >>> 24);
    }

    public static double bytes2double(byte[] b) {
        return ByteUtil.bytes2double(b, 0);
    }

    public static double bytes2double(byte[] b, int off) {
        long l = (long)b[off] << 56 | (long)(b[off + 1] & 0xFF) << 48 | ((long)b[off + 2] & 0xFFL) << 40 | ((long)b[off + 3] & 0xFFL) << 32 | ((long)b[off + 4] & 0xFFL) << 24 | ((long)b[off + 5] & 0xFFL) << 16 | ((long)b[off + 6] & 0xFFL) << 8 | (long)b[off + 7] & 0xFFL;
        return Double.longBitsToDouble(l);
    }

    public static final byte[] double2bytes(double d) {
        byte[] b = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        ByteUtil.double2bytes(d, b, 0);
        return b;
    }

    public static void double2bytes(double d, byte[] b, int off) {
        long l = Double.doubleToLongBits(d);
        b[off + 7] = (byte)l;
        b[off + 6] = (byte)(l >>> 8);
        b[off + 5] = (byte)(l >>> 16);
        b[off + 4] = (byte)(l >>> 24);
        b[off + 3] = (byte)(l >>> 32);
        b[off + 2] = (byte)(l >>> 40);
        b[off + 1] = (byte)(l >>> 48);
        b[off + 0] = (byte)(l >>> 56);
    }

    public static final int makeIntFromByte2(byte[] b) {
        return ByteUtil.makeIntFromByte2(b, 0);
    }

    public static final int makeIntFromByte2(byte[] b, int off) {
        return (b[off] & 0xFF) << 8 | b[off + 1] & 0xFF;
    }

    public static final int makeIntFromByte4(byte[] b) {
        return ByteUtil.makeIntFromByte4(b, 0);
    }

    public static final int makeIntFromByte4(byte[] b, int off) {
        return b[off] << 24 | (b[off + 1] & 0xFF) << 16 | (b[off + 2] & 0xFF) << 8 | b[off + 3] & 0xFF;
    }

    private ByteUtil() {
        throw new UnsupportedOperationException();
    }
}

