/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.util;

import io.craft.atom.util.ByteUtil;
import java.io.Serializable;
import java.util.Arrays;

public final class ByteArrayBuffer
implements Serializable {
    private static final long serialVersionUID = -5219299551050201309L;
    private byte[] buffer;
    private int len;

    public ByteArrayBuffer() {
        this(2048);
    }

    public ByteArrayBuffer(int capacity) {
        this.checkCapacity(capacity);
        this.buffer = new byte[capacity];
    }

    public ByteArrayBuffer(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is null");
        }
        this.buffer = bytes;
        this.len = bytes.length;
    }

    private void checkCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Buffer capacity may not be negative");
        }
    }

    public ByteArrayBuffer append(byte[] b, int off, int len) {
        if (b == null) {
            return this;
        }
        if ((off | len | b.length - off | off + len | b.length - off - len) < 0) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b.length);
        }
        if (len == 0) {
            return this;
        }
        int newlen = this.len + len;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        System.arraycopy(b, off, this.buffer, this.len, len);
        this.len = newlen;
        return this;
    }

    public ByteArrayBuffer append(byte b) {
        int newlen = this.len + 1;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        this.buffer[this.len] = b;
        this.len = newlen;
        return this;
    }

    public ByteArrayBuffer append(byte[] b) {
        if (b == null) {
            return this;
        }
        return this.append(b, 0, b.length);
    }

    public void clear() {
        this.len = 0;
    }

    public void reset(int capacity) {
        this.checkCapacity(capacity);
        this.clear();
        this.buffer = new byte[capacity];
    }

    public byte[] array() {
        return this.array0(0, this.len);
    }

    public byte[] array(int start, int end) {
        if (start < 0 || end < 0 || start > end || end > this.length()) {
            throw new IllegalArgumentException("start=" + start + ", end=" + end + ", len=" + this.length());
        }
        int len = end - start;
        if (len == 0) {
            return new byte[0];
        }
        return this.array0(start, len);
    }

    private byte[] array0(int start, int len) {
        if (start < 0 || len < 0 || start + len > this.length()) {
            throw new IllegalArgumentException("start=" + start + ", len=" + len);
        }
        byte[] b = new byte[len];
        System.arraycopy(this.buffer, start, b, 0, len);
        return b;
    }

    public byte byteAt(int i) {
        return this.buffer[i];
    }

    public int capacity() {
        return this.buffer.length;
    }

    public int length() {
        return this.len;
    }

    public byte[] buffer() {
        return this.buffer;
    }

    public boolean isEmpty() {
        return this.len == 0;
    }

    public boolean isFull() {
        return this.len == this.buffer.length;
    }

    public int indexOf(byte b) {
        return ByteUtil.indexOf(this.buffer, b);
    }

    public int indexOf(byte b, int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex > this.len) {
            endIndex = this.len;
        }
        if (beginIndex >= endIndex) {
            return -1;
        }
        for (int i = beginIndex; i < endIndex; ++i) {
            if (this.buffer[i] != b) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(byte[] bytes) {
        return ByteUtil.indexOf(this.buffer, bytes);
    }

    public int indexOf(byte[] bytes, int beginIndex) {
        if (bytes == null || beginIndex >= this.length()) {
            return -1;
        }
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        return ByteUtil.indexOf(this.buffer, bytes, beginIndex, this.length());
    }

    public int indexOf(byte[] bytes, int beginIndex, int endIndex) {
        if (bytes == null || beginIndex >= endIndex) {
            return -1;
        }
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        return ByteUtil.indexOf(this.buffer, bytes, beginIndex, endIndex);
    }

    private void expand(int newlen) {
        byte[] newbuffer = new byte[Math.max(this.buffer.length << 1, newlen)];
        System.arraycopy(this.buffer, 0, newbuffer, 0, this.len);
        this.buffer = newbuffer;
    }

    public String toString() {
        return "ByteArrayBuffer(buffer=" + Arrays.toString(this.buffer) + ", len=" + this.len + ")";
    }
}

