/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.io;

import io.craft.atom.io.Channel;
import io.craft.atom.io.IoHandler;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIoHandler
implements IoHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIoHandler.class);

    @Override
    public void channelOpened(Channel<byte[]> channel) {
        LOG.debug("[CRAFT-ATOM-IO] Opened |channel={}|", channel);
    }

    @Override
    public void channelClosed(Channel<byte[]> channel) {
        LOG.debug("[CRAFT-ATOM-IO] Closed |channel={}|", channel);
    }

    @Override
    public void channelIdle(Channel<byte[]> channel) {
        LOG.debug("[CRAFT-ATOM-IO] Idle |channel={}|", channel);
    }

    @Override
    public void channelRead(Channel<byte[]> channel, byte[] bytes) {
        LOG.debug("[CRAFT-ATOM-IO] Read |channel={}, bytes={}|", channel, (Object)Arrays.toString(bytes));
    }

    @Override
    public void channelFlush(Channel<byte[]> channel, byte[] bytes) {
        LOG.debug("[CRAFT-ATOM-IO] Flush |channel={}, bytes={}|", channel, (Object)Arrays.toString(bytes));
    }

    @Override
    public void channelWritten(Channel<byte[]> channel, byte[] bytes) {
        LOG.debug("[CRAFT-ATOM-IO] Written |channel={}, bytes={}|", channel, (Object)Arrays.toString(bytes));
    }

    @Override
    public void channelThrown(Channel<byte[]> channel, Exception cause) {
        LOG.warn("[CRAFT-ATOM-IO] Thrown |channel={}|", channel, (Object)cause);
    }
}

