/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.io;

import io.craft.atom.io.AbstractChannel;

public abstract class AbstractIoChannel
extends AbstractChannel {
    protected volatile long lastIoTime = System.currentTimeMillis();
    protected int minReadBufferSize = 64;
    protected int defaultReadBufferSize = 2048;
    protected int maxReadBufferSize = 65536;
    protected int maxWriteBufferSize = this.maxReadBufferSize + (this.maxReadBufferSize >>> 1);

    public AbstractIoChannel() {
    }

    public AbstractIoChannel(long id) {
        super(id);
    }

    public AbstractIoChannel(int minReadBufferSize) {
        this.minReadBufferSize = minReadBufferSize;
    }

    public AbstractIoChannel(int minReadBufferSize, int defaultReadBufferSize) {
        this.minReadBufferSize = minReadBufferSize;
        this.defaultReadBufferSize = defaultReadBufferSize;
    }

    public AbstractIoChannel(int minReadBufferSize, int defaultReadBufferSize, int maxReadBufferSize) {
        this.minReadBufferSize = minReadBufferSize;
        this.defaultReadBufferSize = defaultReadBufferSize;
        this.maxReadBufferSize = maxReadBufferSize;
    }

    public AbstractIoChannel(long lastIoTime, int minReadBufferSize, int defaultReadBufferSize, int maxReadBufferSize, int maxWriteBufferSize) {
        this.lastIoTime = lastIoTime;
        this.minReadBufferSize = minReadBufferSize;
        this.defaultReadBufferSize = defaultReadBufferSize;
        this.maxReadBufferSize = maxReadBufferSize;
        this.maxWriteBufferSize = maxWriteBufferSize;
    }

    public void setMinReadBufferSize(int minReadBufferSize) {
        if (minReadBufferSize <= 0) {
            throw new IllegalArgumentException("minReadBufferSize: " + minReadBufferSize + " (expected: 1+)");
        }
        if (minReadBufferSize > this.defaultReadBufferSize) {
            throw new IllegalArgumentException("minReadBufferSize: " + minReadBufferSize + " (expected: smaller than " + this.defaultReadBufferSize + ')');
        }
        this.minReadBufferSize = minReadBufferSize;
    }

    public void setDefaultReadBufferSize(int defaultReadBufferSize) {
        if (defaultReadBufferSize < this.minReadBufferSize) {
            defaultReadBufferSize = this.minReadBufferSize;
        }
        if (defaultReadBufferSize > this.maxReadBufferSize) {
            defaultReadBufferSize = this.maxReadBufferSize;
        }
        this.defaultReadBufferSize = defaultReadBufferSize;
    }

    public void setMaxReadBufferSize(int maxReadBufferSize) {
        if (maxReadBufferSize <= 0) {
            throw new IllegalArgumentException("maxReadBufferSize: " + maxReadBufferSize + " (expected: > 1)");
        }
        if (maxReadBufferSize < this.defaultReadBufferSize) {
            throw new IllegalArgumentException("maxReadBufferSize: " + maxReadBufferSize + " (expected: greater than " + this.defaultReadBufferSize + ')');
        }
        this.maxReadBufferSize = maxReadBufferSize;
    }

    public void setMaxWriteBufferSize(int maxWriteBufferSize) {
        if (maxWriteBufferSize < this.maxReadBufferSize) {
            maxWriteBufferSize = this.maxReadBufferSize;
        }
        this.maxWriteBufferSize = maxWriteBufferSize;
    }

    @Override
    public String toString() {
        return "AbstractIoChannel(super=" + super.toString() + ")";
    }

    public long getLastIoTime() {
        return this.lastIoTime;
    }

    public void setLastIoTime(long lastIoTime) {
        this.lastIoTime = lastIoTime;
    }

    public int getMinReadBufferSize() {
        return this.minReadBufferSize;
    }

    public int getDefaultReadBufferSize() {
        return this.defaultReadBufferSize;
    }

    public int getMaxReadBufferSize() {
        return this.maxReadBufferSize;
    }

    public int getMaxWriteBufferSize() {
        return this.maxWriteBufferSize;
    }
}

