/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.io;

import io.craft.atom.io.ChannelState;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractChannel {
    private static final AtomicLong ID_GENERATOR = new AtomicLong(0L);
    protected long id;
    protected Map<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
    protected volatile ChannelState state = ChannelState.OPEN;

    public AbstractChannel() {
        this.id = ID_GENERATOR.incrementAndGet();
    }

    public AbstractChannel(long id) {
        this.id = id;
    }

    public boolean isOpen() {
        return this.state == ChannelState.OPEN;
    }

    public boolean isClosing() {
        return this.state == ChannelState.CLOSING;
    }

    public boolean isClosed() {
        return this.state == ChannelState.CLOSED;
    }

    public boolean isPaused() {
        return this.state == ChannelState.PAUSED;
    }

    public void pause() {
        this.state = ChannelState.PAUSED;
    }

    public void resume() {
        this.state = ChannelState.OPEN;
    }

    public void close() {
        this.state = ChannelState.CLOSED;
    }

    public Object getAttribute(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key can not be null");
        }
        return this.attributes.get(key);
    }

    public Object setAttribute(Object key, Object value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("key & value can not be null");
        }
        return this.attributes.put(key, value);
    }

    public boolean containsAttribute(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key can not be null");
        }
        return this.attributes.containsKey(key);
    }

    public Object removeAttribute(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key can not be null");
        }
        return this.attributes.remove(key);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractChannel)) {
            return false;
        }
        AbstractChannel other = (AbstractChannel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getId() == other.getId();
    }

    public boolean canEqual(Object other) {
        return other instanceof AbstractChannel;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        long $id = this.getId();
        result = result * 31 + (int)($id >>> 32 ^ $id);
        return result;
    }

    public String toString() {
        return "AbstractChannel(id=" + this.getId() + ", state=" + (Object)((Object)this.state) + ")";
    }

    public long getId() {
        return this.id;
    }
}

