/*
 * Decompiled with CFR 0.152.
 */
package io.cqser.mediator.spring;

import io.cqser.mediator.core.Command;
import io.cqser.mediator.core.CommandHandler;
import io.cqser.mediator.core.Event;
import io.cqser.mediator.core.EventHandler;
import io.cqser.mediator.core.Registry;
import io.cqser.mediator.core.Request;
import io.cqser.mediator.core.RequestHandler;
import io.cqser.mediator.core.exception.DuplicateCommandHandlerRegistrationException;
import io.cqser.mediator.core.exception.DuplicateRequestHandlerRegistrationException;
import io.cqser.mediator.core.exception.NoCommandHandlerException;
import io.cqser.mediator.core.exception.NoEventHandlersException;
import io.cqser.mediator.core.exception.NoRequestHandlerException;
import io.cqser.mediator.spring.CommandHandlerProvider;
import io.cqser.mediator.spring.EventHandlerProvider;
import io.cqser.mediator.spring.RequestHandlerProvider;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.GenericTypeResolver;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\b\b\u0000\u0010\u0013*\u00020\b2\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00130\u0007H\u0016J:\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u00160\u0015\"\u000e\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00160\u000f\"\u0004\b\u0001\u0010\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00130\u0007H\u0016J.\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001a0\u00190\u0018\"\b\b\u0000\u0010\u001a*\u00020\u000b2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001a0\u0007H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u001a\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\n\u001a \u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000f0\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/cqser/mediator/spring/SpringRegistry;", "Lio/cqser/mediator/core/Registry;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "(Lorg/springframework/context/ApplicationContext;)V", "commandRegistry", "", "Ljava/lang/Class;", "Lio/cqser/mediator/core/Command;", "Lio/cqser/mediator/spring/CommandHandlerProvider;", "eventRegistry", "Lio/cqser/mediator/core/Event;", "", "Lio/cqser/mediator/spring/EventHandlerProvider;", "requestRegistry", "Lio/cqser/mediator/core/Request;", "Lio/cqser/mediator/spring/RequestHandlerProvider;", "get", "Lio/cqser/mediator/core/CommandHandler;", "C", "commandClass", "Lio/cqser/mediator/core/RequestHandler;", "R", "requestClass", "", "Lio/cqser/mediator/core/EventHandler;", "E", "eventClass", "registerCommandHandler", "", "name", "", "registerEventHandler", "registerRequestHandler", "Companion", "cqser-spring-data-jpa"})
public final class SpringRegistry
implements Registry {
    private final Map<Class<? extends Request<?>>, RequestHandlerProvider<?>> requestRegistry;
    private final Map<Class<? extends Event>, Set<EventHandlerProvider<?>>> eventRegistry;
    private final Map<Class<? extends Command>, CommandHandlerProvider<?>> commandRegistry;
    private final ApplicationContext applicationContext;
    @NotNull
    private static final Logger logger;
    private static boolean isInitialized;
    public static final Companion Companion;

    @Override
    @NotNull
    public <C extends Request<? extends R>, R> RequestHandler<C, R> get(@NotNull Class<? extends C> requestClass) {
        Intrinsics.checkParameterIsNotNull(requestClass, (String)"requestClass");
        Companion.initHandlersIfNecessary(this);
        RequestHandlerProvider<?> requestHandlerProvider = this.requestRegistry.get(requestClass);
        if (requestHandlerProvider != null) {
            RequestHandlerProvider<?> requestHandlerProvider2;
            RequestHandlerProvider<?> provider = requestHandlerProvider2 = requestHandlerProvider;
            Object obj = provider.get();
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.cqser.mediator.core.RequestHandler<C, R>");
            }
            return obj;
        }
        throw (Throwable)new NoRequestHandlerException("No RequestHandler is registered to handle request of type " + requestClass.getCanonicalName());
    }

    @Override
    @NotNull
    public <E extends Event> Set<EventHandler<E>> get(@NotNull Class<? extends E> eventClass) {
        Intrinsics.checkParameterIsNotNull(eventClass, (String)"eventClass");
        Companion.initHandlersIfNecessary(this);
        Set handlers = new LinkedHashSet();
        Set<EventHandlerProvider<?>> set = this.eventRegistry.get(eventClass);
        if (set != null) {
            Set<EventHandlerProvider<?>> set2;
            Set<EventHandlerProvider<?>> providers = set2 = set;
            for (EventHandlerProvider<?> provider : providers) {
                Object handler;
                if (provider.get() == null) {
                    throw new TypeCastException("null cannot be cast to non-null type io.cqser.mediator.core.EventHandler<E>");
                }
                handlers.add(handler);
            }
        } else {
            throw (Throwable)new NoEventHandlersException("No EventHandlers are registered to handle event of type " + eventClass.getCanonicalName());
        }
        return handlers;
    }

    @Override
    @NotNull
    public <C extends Command> CommandHandler<C> get(@NotNull Class<? extends C> commandClass) {
        Intrinsics.checkParameterIsNotNull(commandClass, (String)"commandClass");
        Companion.initHandlersIfNecessary(this);
        CommandHandlerProvider<?> commandHandlerProvider = this.commandRegistry.get(commandClass);
        if (commandHandlerProvider != null) {
            CommandHandlerProvider<?> commandHandlerProvider2;
            CommandHandlerProvider<?> provider = commandHandlerProvider2 = commandHandlerProvider;
            Object obj = provider.get();
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.cqser.mediator.core.CommandHandler<C>");
            }
            return obj;
        }
        throw (Throwable)new NoCommandHandlerException("No CommandHandler is registered to handle request of type " + commandClass.getCanonicalName());
    }

    private final void registerRequestHandler(String name) {
        block3: {
            Class[] classArray;
            Class[] generics;
            logger.debug("Registering RequestHandler with name " + name);
            Object object = this.applicationContext.getBean(name);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.cqser.mediator.core.RequestHandler<*, *>");
            }
            RequestHandler handler = (RequestHandler)object;
            if (generics == null) break block3;
            Class[] it = classArray = (generics = GenericTypeResolver.resolveTypeArguments(handler.getClass(), RequestHandler.class));
            Class clazz = it[0];
            if (clazz == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<out io.cqser.mediator.core.Request<*>>");
            }
            Map<Class<Request<?>>, RequestHandlerProvider<?>> map = this.requestRegistry;
            Map<Class<Request<?>>, RequestHandlerProvider<?>> map2 = map;
            Class requestType = clazz;
            if (map2.containsKey(requestType)) {
                throw (Throwable)new DuplicateRequestHandlerRegistrationException(requestType.getCanonicalName() + " already has a registered handler. Each request must have a single request handler");
            }
            RequestHandlerProvider requestProvider = new RequestHandlerProvider(this.applicationContext, Reflection.getOrCreateKotlinClass(handler.getClass()));
            map2 = this.requestRegistry;
            RequestHandlerProvider requestHandlerProvider = requestProvider;
            map2.put(requestType, requestHandlerProvider);
            logger.info("Registered RequestHandler " + Reflection.getOrCreateKotlinClass(handler.getClass()).getSimpleName() + " to handle Request " + requestType.getSimpleName());
        }
    }

    private final void registerEventHandler(String name) {
        block4: {
            Class[] classArray;
            Class[] generics;
            logger.debug("Registering EventHandler with name " + name);
            Object object = this.applicationContext.getBean(name);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.cqser.mediator.core.EventHandler<*>");
            }
            EventHandler eventHandler = (EventHandler)object;
            if (generics == null) break block4;
            Class[] it = classArray = (generics = GenericTypeResolver.resolveTypeArguments(eventHandler.getClass(), EventHandler.class));
            Class clazz = it[0];
            if (clazz == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<out io.cqser.mediator.core.Event>");
            }
            Class eventType = clazz;
            EventHandlerProvider eventProvider = new EventHandlerProvider(this.applicationContext, Reflection.getOrCreateKotlinClass(eventHandler.getClass()));
            Set<EventHandlerProvider<?>> set = this.eventRegistry.get(eventType);
            if (set != null) {
                set.add(eventProvider);
            } else {
                Map<Class<Event>, Set<EventHandlerProvider<?>>> map = this.eventRegistry;
                Class clazz2 = eventType;
                Set set2 = SetsKt.mutableSetOf((Object[])new EventHandlerProvider[]{eventProvider});
                map.put(clazz2, set2);
            }
            logger.info("Register EventHandler " + Reflection.getOrCreateKotlinClass(eventHandler.getClass()).getSimpleName() + " to handle Event " + eventType.getSimpleName());
        }
    }

    private final void registerCommandHandler(String name) {
        block3: {
            Class[] classArray;
            Class[] generics;
            logger.debug("Registering CommandHandler with name " + name);
            Object object = this.applicationContext.getBean(name);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.cqser.mediator.core.CommandHandler<*>");
            }
            CommandHandler commandHandler = (CommandHandler)object;
            if (generics == null) break block3;
            Class[] it = classArray = (generics = GenericTypeResolver.resolveTypeArguments(commandHandler.getClass(), CommandHandler.class));
            Class clazz = it[0];
            if (clazz == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<out io.cqser.mediator.core.Command>");
            }
            Class commandType = clazz;
            if (this.commandRegistry.containsKey(commandType)) {
                throw (Throwable)new DuplicateCommandHandlerRegistrationException(commandType.getCanonicalName() + " already has a registered handler. Each command must have a single command handler");
            }
            CommandHandlerProvider commandHandlerProvider = new CommandHandlerProvider(this.applicationContext, Reflection.getOrCreateKotlinClass(commandHandler.getClass()));
            Map<Class<Command>, CommandHandlerProvider<?>> map = this.commandRegistry;
            CommandHandlerProvider commandHandlerProvider2 = commandHandlerProvider;
            map.put(commandType, commandHandlerProvider2);
            logger.info("Registered CommandHandler " + Reflection.getOrCreateKotlinClass(commandHandler.getClass()).getSimpleName() + " to handle Command " + commandType.getSimpleName());
        }
    }

    public SpringRegistry(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkParameterIsNotNull((Object)applicationContext, (String)"applicationContext");
        this.applicationContext = applicationContext;
        this.requestRegistry = new HashMap();
        this.eventRegistry = new HashMap();
        this.commandRegistry = new HashMap();
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(SpringRegistry.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(\u2026ringRegistry::class.java)");
        SpringRegistry.logger = logger;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/cqser/mediator/spring/SpringRegistry$Companion;", "", "()V", "isInitialized", "", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "initHandlersIfNecessary", "", "springRegistry", "Lio/cqser/mediator/spring/SpringRegistry;", "cqser-spring-data-jpa"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public final void initHandlersIfNecessary(@NotNull SpringRegistry springRegistry) {
            String element$iv;
            String it;
            int n;
            Intrinsics.checkParameterIsNotNull((Object)springRegistry, (String)"springRegistry");
            if (isInitialized) {
                return;
            }
            String[] stringArray = springRegistry.applicationContext.getBeanNamesForType(RequestHandler.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"springRegistry.applicati\u2026questHandler::class.java)");
            String[] $receiver$iv = stringArray;
            int n2 = $receiver$iv.length;
            for (n = 0; n < n2; ++n) {
                String string = it = (element$iv = $receiver$iv[n]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                springRegistry.registerRequestHandler(string);
            }
            String[] stringArray2 = springRegistry.applicationContext.getBeanNamesForType(EventHandler.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringArray2, (String)"springRegistry.applicati\u2026EventHandler::class.java)");
            $receiver$iv = stringArray2;
            n2 = $receiver$iv.length;
            for (n = 0; n < n2; ++n) {
                String string = it = (element$iv = $receiver$iv[n]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                springRegistry.registerEventHandler(string);
            }
            String[] stringArray3 = springRegistry.applicationContext.getBeanNamesForType(CommandHandler.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringArray3, (String)"springRegistry.applicati\u2026mmandHandler::class.java)");
            $receiver$iv = stringArray3;
            n2 = $receiver$iv.length;
            for (n = 0; n < n2; ++n) {
                String string = it = (element$iv = $receiver$iv[n]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                springRegistry.registerCommandHandler(string);
            }
            isInitialized = true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

