/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.rest.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.cortical.rest.model.Fingerprint;
import io.cortical.rest.model.Model;
import io.cortical.rest.model.Term;
import io.cortical.rest.model.Text;
import org.apache.commons.lang3.ArrayUtils;

public class ExpressionFactory {
    public static ExpressionModel and(Model ... models) {
        return new AndExpression().add(models);
    }

    public static ExpressionModel or(Model ... models) {
        return new OrExpression().add(models);
    }

    public static ExpressionModel xor(Model ... models) {
        return new XorExpression().add(models);
    }

    public static ExpressionModel sub(Model ... models) {
        return new SubExpression().add(models);
    }

    public static Text text(String text) {
        return new Text(text);
    }

    public static Term term(String term) {
        return new Term(term);
    }

    public static Fingerprint fingerprint(int ... items) {
        Fingerprint fingerprint = new Fingerprint(items);
        return fingerprint;
    }

    private static class SubExpression
    extends ExpressionModel {
        private Model[] sub = new Model[0];

        private SubExpression() {
        }

        @Override
        public ExpressionModel add(Model ... models) {
            this.sub = (Model[])ArrayUtils.addAll((Object[])this.sub, (Object[])models);
            return this;
        }
    }

    private static class XorExpression
    extends ExpressionModel {
        private Model[] xor = new Model[0];

        private XorExpression() {
        }

        @Override
        public ExpressionModel add(Model ... models) {
            this.xor = (Model[])ArrayUtils.addAll((Object[])this.xor, (Object[])models);
            return this;
        }
    }

    private static class OrExpression
    extends ExpressionModel {
        private Model[] or = new Model[0];

        private OrExpression() {
        }

        @Override
        public ExpressionModel add(Model ... models) {
            this.or = (Model[])ArrayUtils.addAll((Object[])this.or, (Object[])models);
            return this;
        }
    }

    private static class AndExpression
    extends ExpressionModel {
        private Model[] and = new Model[0];

        private AndExpression() {
        }

        @Override
        public ExpressionModel add(Model ... models) {
            this.and = (Model[])ArrayUtils.addAll((Object[])this.and, (Object[])models);
            return this;
        }
    }

    public static abstract class ExpressionModel
    extends Model {
        public abstract ExpressionModel add(Model ... var1);

        @Override
        public String toJson() throws JsonProcessingException {
            return super.toJson();
        }
    }
}

