/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.example;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.cortical.rest.model.Context;
import io.cortical.rest.model.ExpressionFactory;
import io.cortical.rest.model.Fingerprint;
import io.cortical.rest.model.Image;
import io.cortical.rest.model.Metric;
import io.cortical.rest.model.Model;
import io.cortical.rest.model.Retina;
import io.cortical.rest.model.Term;
import io.cortical.rest.model.Text;
import io.cortical.services.Compare;
import io.cortical.services.Expressions;
import io.cortical.services.Images;
import io.cortical.services.Pagination;
import io.cortical.services.PosTag;
import io.cortical.services.PosType;
import io.cortical.services.RetinaApis;
import io.cortical.services.Retinas;
import io.cortical.services.Terms;
import io.cortical.services.Texts;
import io.cortical.services.api.client.ApiException;
import io.cortical.services.api.client.api.ExpressionsApi;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExampleMain {
    private static final Log LOG = LogFactory.getLog(ExampleMain.class);
    private static final String RETINA_NAME = "en_associative";
    private static final String RETINA_IP = "s_api.cortical.io";
    private static final Short RETINA_PORT = 80;
    private static final String API_KEY = "4faf0e50-e8b0-45b5-8783-e31f84a1dce5";
    private static final Text TEXT_1 = new Text("the first text to use");
    private static final Text TEXT_2 = ExpressionFactory.text((String)"the second text to use");
    private static final Term TERM_1 = new Term("term");
    private static final Term TERM_2 = ExpressionFactory.term((String)"second");
    private final RetinaApis retinaApisInstance = new RetinaApis("en_associative", "s_api.cortical.io", "4faf0e50-e8b0-45b5-8783-e31f84a1dce5");

    public static void main(String[] args) throws Exception {
        LOG.info((Object)"Start the example....");
        ExampleMain start = new ExampleMain();
        start.compareApiUsage();
        start.expressionsApiUsage();
        start.imageApiUsage();
        start.retinasApiUsage();
        start.termsApiUsage();
        start.textApiUsage();
    }

    private void compareApiUsage() throws ApiException, JsonProcessingException {
        Metric[] metrics;
        LOG.info((Object)"The Compare API usage.");
        Compare compareApiInstance = this.retinaApisInstance.compareApi();
        LOG.info((Object)"Compare API: compare");
        Metric metric = compareApiInstance.compare((Model)new Term("apple"), (Model)new Term("banana"));
        this.logMetric(metric);
        String inputText = "Gustav Klimt (July 14, 1862 \u2013 February 6, 1918) was an Austrian symbolist painter and one of the most prominent members of the Vienna Secession movement. Klimt is noted for his paintings, murals, sketches, and other objets d'art. Klimt's primary subject was the female body;[1] his works are marked by a frank eroticism.[2]";
        metric = compareApiInstance.compare((Model)new Term("painter"), (Model)new Text(inputText));
        this.logMetric(metric);
        LOG.info((Object)"Compare API: compareBulk");
        Compare.CompareModels toCompare1 = new Compare.CompareModels((Model)new Term("apple"), (Model)new Term("banana"));
        Compare.CompareModels toCompare2 = new Compare.CompareModels((Model)new Term("banana"), (Model)new Term("fruit"));
        Compare.CompareModels toCompare3 = new Compare.CompareModels((Model)new Term("apple"), (Model)new Term("orange"));
        Compare.CompareModels[] toCompareBulk = new Compare.CompareModels[]{toCompare1, toCompare2, toCompare3};
        for (Metric metricFromBulk : metrics = compareApiInstance.compareBulk(toCompareBulk)) {
            this.logMetric(metricFromBulk);
        }
    }

    private void logMetric(Metric metric) {
        LOG.info((Object)("Metric: Cosine Similarity: " + metric.getCosineSimilarity() + "  Euclidean Distance: " + metric.getEuclideanDistance() + "  Jaccard Distance: " + metric.getJaccardDistance() + "  Over lappingAll: " + metric.getOverlappingAll() + "  Over lapping Left Right: " + metric.getOverlappingLeftRight() + "  Over lapping Right Left: " + metric.getOverlappingRightLeft() + "  Size Left: " + metric.getSizeLeft() + "  Size Right: " + metric.getSizeRight() + "  Weighted Scoring: " + metric.getWeightedScoring()));
    }

    private void expressionsApiUsage() throws JsonProcessingException, ApiException {
        LOG.info((Object)"The Expressions API usage.");
        Expressions api = this.retinaApisInstance.expressionsApi();
        ExpressionsApi expressionsApi = new ExpressionsApi(API_KEY);
        expressionsApi.setBasePath("http://api.cortical.io/rest");
        LOG.info((Object)"Expressions API: getContextsForExpression");
        List bulkContexts = api.getContextsBulk(new Model[]{TERM_1, TERM_2, TERM_2});
        this.logBulkContexts(bulkContexts);
        bulkContexts = api.getContextsBulk(Boolean.valueOf(true), new Model[]{TERM_1, ExpressionFactory.or((Model[])new Model[]{TERM_2, TEXT_2}).add(new Model[]{TERM_1}), TEXT_1});
        this.logBulkContexts(bulkContexts);
        bulkContexts = api.getContextsBulk(Double.valueOf(1.0), new Model[]{TERM_1, TERM_2, ExpressionFactory.or((Model[])new Model[]{TERM_2, TEXT_2}).add(new Model[]{TERM_1})});
        this.logBulkContexts(bulkContexts);
        bulkContexts = api.getContextsBulk(Boolean.valueOf(true), Double.valueOf(1.0), new Model[]{TERM_1, ExpressionFactory.or((Model[])new Model[]{TERM_2, TEXT_2}).add(new Model[]{TERM_1}), TEXT_1});
        this.logBulkContexts(bulkContexts);
        bulkContexts = api.getContextsBulk(new Pagination(Integer.valueOf(0), Integer.valueOf(2)), Boolean.valueOf(true), Double.valueOf(1.0), new Model[]{TERM_1, TERM_2, ExpressionFactory.or((Model[])new Model[]{TERM_2, TEXT_2})});
        this.logBulkContexts(bulkContexts);
        LOG.info((Object)"Expressions API: getContextsForExpression");
        List contexts = api.getContexts((Model)TERM_1);
        this.logContext(contexts);
        contexts = api.getContexts((Model)ExpressionFactory.or((Model[])new Model[]{TERM_2, TEXT_2}));
        this.logContext(contexts);
        contexts = api.getContexts(Boolean.valueOf(true), (Model)ExpressionFactory.or((Model[])new Model[]{TERM_2, TEXT_2}));
        this.logContext(contexts);
        contexts = api.getContexts(Double.valueOf(0.1), (Model)ExpressionFactory.sub((Model[])new Model[]{TERM_2, TERM_1}));
        this.logContext(contexts);
        contexts = api.getContexts(Boolean.valueOf(true), Double.valueOf(1.0), (Model)ExpressionFactory.and((Model[])new Model[]{TERM_2, TERM_1}));
        this.logContext(contexts);
        contexts = api.getContexts(new Pagination(Integer.valueOf(0), Integer.valueOf(2)), Boolean.valueOf(true), Double.valueOf(1.0), (Model)ExpressionFactory.xor((Model[])new Model[]{TERM_2, TERM_1}));
        this.logContext(contexts);
        LOG.info((Object)"Expressions API: getSimilarTermsForBulkExpressionContext");
        List bulkTerms = api.getSimilarTermsBulk(null, PosType.ADJECTIVE, new Model[]{TERM_1, ExpressionFactory.and((Model[])new Model[]{TERM_2, TEXT_2}), TEXT_1});
        this.logBulkTerms(bulkTerms);
        bulkTerms = api.getSimilarTermsBulk(Integer.valueOf(1), PosType.ADJECTIVE, Boolean.valueOf(true), new Model[]{TERM_1, TERM_2, TEXT_1});
        this.logBulkTerms(bulkTerms);
        bulkTerms = api.getSimilarTermsBulk(Integer.valueOf(1), PosType.ADJECTIVE, Double.valueOf(1.0), new Model[]{TERM_1, ExpressionFactory.and((Model[])new Model[]{TERM_2, TEXT_2}).add(new Model[]{TERM_1}), TEXT_1});
        this.logBulkTerms(bulkTerms);
        bulkTerms = api.getSimilarTermsBulk(Integer.valueOf(1), PosType.ADJECTIVE, Boolean.valueOf(true), Double.valueOf(1.0), new Model[]{TERM_1, ExpressionFactory.and((Model[])new Model[]{TERM_2, TEXT_2}).add(new Model[]{TERM_1}), TEXT_1});
        this.logBulkTerms(bulkTerms);
        bulkTerms = api.getSimilarTermsBulk(Integer.valueOf(1), PosType.ADJECTIVE, new Pagination(Integer.valueOf(1), Integer.valueOf(2)), Boolean.valueOf(true), Double.valueOf(1.0), new Model[]{TERM_1, TERM_2, TEXT_1});
        this.logBulkTerms(bulkTerms);
        LOG.info((Object)"Expressions API: resolveExpression");
        Fingerprint fingerprint = api.resolve((Model)TERM_1);
        this.logFingerprint(fingerprint);
        fingerprint = api.resolve(Double.valueOf(1.0), (Model)ExpressionFactory.and((Model[])new Model[]{TERM_1, TEXT_1}));
        this.logFingerprint(fingerprint);
        LOG.info((Object)"Expressions API: getSimilarTermsForExpressionContext");
        List terms = api.getSimilarTerms(null, null, (Model)TEXT_1);
        this.logTerms(terms);
        terms = api.getSimilarTerms((Model)TEXT_2);
        this.logTerms(terms);
        String bodyText = "{ \"text\": \"the first text to use\"}";
        List similarterms = expressionsApi.getSimilarTermsForExpressionContext(bodyText, null, null, Boolean.valueOf(false), RETINA_NAME, null, null, null);
        this.logTerms(similarterms);
        terms = api.getSimilarTerms(null, PosType.NOUN, (Model)ExpressionFactory.and((Model[])new Model[]{TERM_2, TEXT_2}).add(new Model[]{TERM_1}));
        this.logTerms(terms);
    }

    private void imageApiUsage() throws ApiException, IOException {
        LOG.info((Object)"The Image API usage.");
        Images api = this.retinaApisInstance.imageApi();
        LOG.info((Object)"Image API: getImageForExpression");
        try (ByteArrayInputStream inputStream = api.getImage((Model)TEXT_1);){
            if (inputStream.read() == 0) {
                throw new IllegalStateException("A image stream cannot be received.");
            }
        }
        LOG.info((Object)"Image API: getOverlayImage");
        inputStream = api.compare((Model)TEXT_1, (Model)TEXT_2);
        var3_3 = null;
        try {
            if (inputStream.read() == 0) {
                throw new IllegalStateException("A image stream cannot be received.");
            }
        }
        catch (Throwable x2) {
            var3_3 = x2;
            throw x2;
        }
        finally {
            if (inputStream != null) {
                if (var3_3 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable x2) {
                        var3_3.addSuppressed(x2);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
        LOG.info((Object)"Image API: getImageForBulkExpressions");
        List images = api.getImageBulk(new Model[]{TEXT_1, TERM_1});
        for (Image image : images) {
            LOG.info((Object)("Image: imageData size: " + image.getImageData().length));
        }
    }

    private void retinasApiUsage() throws ApiException {
        LOG.info((Object)"The Retinas API usage.");
        Retinas api = RetinaApis.getInfo((String)"api.cortical.io", (String)API_KEY);
        LOG.info((Object)"Retinas API: getRetinas");
        List retinas = api.getAllRetinas();
        for (Retina retina : retinas) {
            LOG.info((Object)("Retina:  Name: " + retina.getRetinaName() + "  Description: " + retina.getRetinaDescription() + "  Terms in the retina:  " + retina.getNumberOfTermsInRetina()));
        }
        Retina retina = api.retinaByName(RETINA_NAME);
        LOG.info((Object)("Retina:  Name: " + retina.getRetinaName() + "  Description: " + retina.getRetinaDescription() + "  Terms in the retina:  " + retina.getNumberOfTermsInRetina()));
    }

    private void termsApiUsage() throws JsonProcessingException, ApiException {
        LOG.info((Object)"The Terms API usage.");
        Terms api = this.retinaApisInstance.termsApi();
        LOG.info((Object)"Terms API: getContextsForTerm");
        List contexts = api.getContexts("apple");
        this.logContext(contexts);
        contexts = api.getContexts("apple", new Pagination(Integer.valueOf(0), Integer.valueOf(2)), Boolean.valueOf(true));
        this.logContext(contexts);
        LOG.info((Object)"Terms API: getSimilarTerms");
        List terms = api.getSimilarTerms("tiger");
        this.logTerms(terms);
        terms = api.getSimilarTerms("tiger", null, PosType.NOUN);
        this.logTerms(terms);
        terms = api.getSimilarTerms("tiger", null, PosType.NOUN, Boolean.valueOf(true));
        this.logTerms(terms);
        LOG.info((Object)"Terms API: getTerm");
        terms = api.getTerm("apple");
        this.logTerms(terms);
        System.out.println();
        terms = api.getTerm("banana", new Pagination(Integer.valueOf(0), Integer.valueOf(2)), Boolean.valueOf(true));
        this.logTerms(terms);
        System.out.println();
        LOG.info((Object)"Terms API: getTerm NULL TEST");
        terms = api.getTerm(null);
        this.logTerms(terms);
    }

    private void textApiUsage() throws ApiException, JsonProcessingException {
        String text = "Toll IPEC has been an industry leader in environmental sustainability through its purchase of compressed natural gas powered trucks";
        String text2 = "Shellshock can serve as a highway for worms and malware to hit your Unix, Linux, and Mac servers, but you can defend against it.";
        String text3 = "However, Shellshock is not as bad as HeartBleed. Not yet, anyway.";
        LOG.info((Object)"The Text API usage.");
        Texts api = this.retinaApisInstance.textApi();
        LOG.info((Object)"Text API: getKeywordsForText");
        List keywords = api.getKeywords(text);
        this.logKeywords(keywords);
        LOG.info((Object)"Text API: getRepresentationForText");
        List fingerprints = api.getFingerprints(text2);
        this.logFingerprints(fingerprints);
        LOG.info((Object)"Text API: getRepresentationsForBulkText");
        fingerprints = api.getFingerprintBulk(Double.valueOf(0.1), new Text[]{TEXT_1, TEXT_2});
        this.logFingerprints(fingerprints);
        LOG.info((Object)"Text API: getSlicesForText");
        List texts = api.getSlices(text);
        this.logTexts(texts);
        texts = api.getSlices(text3, new Pagination(Integer.valueOf(0), Integer.valueOf(2)), Boolean.valueOf(true));
        this.logTexts(texts);
        LOG.info((Object)"Text API: getTokensForText");
        List tokens = api.getTokens(text2, new PosTag[]{PosTag.CC, PosTag.LRB});
        this.logTokens(tokens);
        tokens = api.getTokens(text2, new PosTag[0]);
        this.logTokens(tokens);
    }

    private void logBulkContexts(List<List<Context>> bulkContexts) {
        for (List<Context> list : bulkContexts) {
            this.logContext(list);
        }
    }

    private void logContext(Context context) {
        LOG.info((Object)("Context: context_label: " + context.getContextLabel() + "  Context Id: " + context.getContextId() + "  Context fingerprint isNullorEmpty: " + (context.getFingerprint() == null || context.getFingerprint().getPositions() == null || context.getFingerprint().getPositions().length == 0)));
    }

    private void logContext(List<Context> contexts) {
        for (Context context : contexts) {
            this.logContext(context);
        }
    }

    private void logFingerprint(Fingerprint fingerprint) {
        LOG.info((Object)("Fingerprint: " + fingerprint.getPositions().toString()));
    }

    private void logFingerprints(List<Fingerprint> fingerprints) {
        for (Fingerprint fingerprint : fingerprints) {
            this.logFingerprint(fingerprint);
        }
    }

    private void logBulkTerms(List<List<Term>> bulkTerms) {
        for (List<Term> list : bulkTerms) {
            this.logTerms(list);
        }
    }

    private void logTerms(List<Term> terms) {
        for (Term term : terms) {
            this.logTerm(term);
        }
    }

    private void logTerm(Term term) {
        LOG.info((Object)("Term:  term: " + term.getTerm() + "  Score: " + term.getScore() + "  Score Types:   " + term.getPosTypes()));
    }

    private void logKeyword(String keyword) {
        LOG.info((Object)("Keyword:  " + keyword));
    }

    private void logKeywords(List<String> keywords) {
        for (String keyword : keywords) {
            this.logKeyword(keyword);
        }
    }

    private void logToken(String token) {
        LOG.info((Object)("Keyword:  " + token));
    }

    private void logTokens(List<String> tokens) {
        for (String keyword : tokens) {
            this.logToken(keyword);
        }
    }

    private void logText(Text text) {
        LOG.info((Object)("Text: " + text.getText()));
    }

    private void logTexts(List<Text> texts) {
        for (Text text : texts) {
            this.logText(text);
        }
    }
}

