/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.services.api.client.api;

import io.cortical.rest.model.Fingerprint;
import io.cortical.rest.model.Retina;
import io.cortical.rest.model.Text;
import io.cortical.services.api.client.ApiException;
import io.cortical.services.api.client.ApiInvoker;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;

public class TextApi {
    private String basePath = "http://api.cortical.io/rest";
    private String key = "replaceWithRetinaAPIKey";
    private ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public TextApi(String apiKey) {
        this.key = apiKey;
        this.apiInvoker.addDefaultHeader("api-key", apiKey);
    }

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public List<Fingerprint> getRepresentationForText(String body, String retina_name) throws ApiException {
        block8: {
            if (retina_name == null || body == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/text".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, body, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        List result = (List)ApiInvoker.deserialize((String)response, "Array", Fingerprint.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        List result = (List)response;
                        return result;
                    }
                    break block8;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    public List<String> getKeywordsForText(String body, String retina_name) throws ApiException {
        block8: {
            if (retina_name == null || body == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/text/keywords".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, body, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        List result = (List)ApiInvoker.deserialize((String)response, "Array", String.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        List result = (List)response;
                        return result;
                    }
                    break block8;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    public List<String> getTokensForText(String body, String POStags, String retina_name) throws ApiException {
        block9: {
            if (retina_name == null || body == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/text/tokenize".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(POStags))) {
                queryParams.put("POStags", String.valueOf(POStags));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, body, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        List result = (List)ApiInvoker.deserialize((String)response, "Array", String.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        List result = (List)response;
                        return result;
                    }
                    break block9;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    public List<Text> getSlicesForText(String body, Boolean get_fingerprint, String retina_name, Integer start_index, Integer max_results) throws ApiException {
        block11: {
            if (retina_name == null || body == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/text/slices".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(start_index))) {
                queryParams.put("start_index", String.valueOf(start_index));
            }
            if (!"null".equals(String.valueOf(max_results))) {
                queryParams.put("max_results", String.valueOf(max_results));
            }
            if (!"null".equals(String.valueOf(get_fingerprint))) {
                queryParams.put("get_fingerprint", String.valueOf(get_fingerprint));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, body, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        List result = (List)ApiInvoker.deserialize((String)response, "Array", Text.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        List result = (List)response;
                        return result;
                    }
                    break block11;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    public List<Fingerprint> getRepresentationsForBulkText(String body, String retina_name, Double sparsity) throws ApiException {
        block9: {
            if (retina_name == null || body == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/text/bulk".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(sparsity))) {
                queryParams.put("sparsity", String.valueOf(sparsity));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, body, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        List result = (List)ApiInvoker.deserialize((String)response, "Array", Fingerprint.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        List result = (List)response;
                        return result;
                    }
                    break block9;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    public Retina getLanguage(String body) throws ApiException {
        block7: {
            if (body == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/text/detect_language".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, body, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        Retina result = (Retina)ApiInvoker.deserialize((String)response, "", Retina.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        Retina result = (Retina)response;
                        return result;
                    }
                    break block7;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }
}

