/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.services.api.client.api;

import io.cortical.rest.model.Context;
import io.cortical.rest.model.Term;
import io.cortical.services.api.client.ApiException;
import io.cortical.services.api.client.ApiInvoker;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;

public class TermsApi {
    private String basePath = "http://api.cortical.io/rest";
    private String key = "replaceWithRetinaAPIKey";
    private ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public TermsApi(String apiKey) {
        this.key = apiKey;
        this.apiInvoker.addDefaultHeader("api-key", apiKey);
    }

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public List<Term> getTerm(String term, Boolean get_fingerprint, String retina_name, Integer start_index, Integer max_results) throws ApiException {
        block12: {
            if (retina_name == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/terms".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(term))) {
                queryParams.put("term", String.valueOf(term));
            }
            if (!"null".equals(String.valueOf(start_index))) {
                queryParams.put("start_index", String.valueOf(start_index));
            }
            if (!"null".equals(String.valueOf(max_results))) {
                queryParams.put("max_results", String.valueOf(max_results));
            }
            if (!"null".equals(String.valueOf(get_fingerprint))) {
                queryParams.put("get_fingerprint", String.valueOf(get_fingerprint));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, null, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        List result = (List)ApiInvoker.deserialize((String)response, "Array", Term.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        List result = (List)response;
                        return result;
                    }
                    break block12;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    public List<Context> getContextsForTerm(String term, Boolean get_fingerprint, String retina_name, Integer start_index, Integer max_results) throws ApiException {
        block12: {
            if (retina_name == null || term == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/terms/contexts".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(term))) {
                queryParams.put("term", String.valueOf(term));
            }
            if (!"null".equals(String.valueOf(start_index))) {
                queryParams.put("start_index", String.valueOf(start_index));
            }
            if (!"null".equals(String.valueOf(max_results))) {
                queryParams.put("max_results", String.valueOf(max_results));
            }
            if (!"null".equals(String.valueOf(get_fingerprint))) {
                queryParams.put("get_fingerprint", String.valueOf(get_fingerprint));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, null, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        List result = (List)ApiInvoker.deserialize((String)response, "Array", Context.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        List result = (List)response;
                        return result;
                    }
                    break block12;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    public List<Term> getSimilarTerms(String term, Integer context_id, String pos_type, Boolean get_fingerprint, String retina_name, Integer start_index, Integer max_results) throws ApiException {
        block14: {
            if (retina_name == null || term == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/terms/similar_terms".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(term))) {
                queryParams.put("term", String.valueOf(term));
            }
            if (!"null".equals(String.valueOf(context_id))) {
                queryParams.put("context_id", String.valueOf(context_id));
            }
            if (!"null".equals(String.valueOf(start_index))) {
                queryParams.put("start_index", String.valueOf(start_index));
            }
            if (!"null".equals(String.valueOf(max_results))) {
                queryParams.put("max_results", String.valueOf(max_results));
            }
            if (!"null".equals(String.valueOf(pos_type))) {
                queryParams.put("pos_type", String.valueOf(pos_type));
            }
            if (!"null".equals(String.valueOf(get_fingerprint))) {
                queryParams.put("get_fingerprint", String.valueOf(get_fingerprint));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, null, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        List result = (List)ApiInvoker.deserialize((String)response, "Array", Term.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        List result = (List)response;
                        return result;
                    }
                    break block14;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }
}

