/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.services.api.client.api;

import io.cortical.rest.model.Context;
import io.cortical.rest.model.Fingerprint;
import io.cortical.rest.model.Term;
import io.cortical.services.api.client.ApiException;
import io.cortical.services.api.client.ApiInvoker;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;

public class ExpressionsApi {
    private String basePath = "http://api.cortical.io/rest";
    private String key = "replaceWithRetinaAPIKey";
    private ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public ExpressionsApi(String apiKey) {
        this.key = apiKey;
        this.apiInvoker.addDefaultHeader("api-key", apiKey);
    }

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public Fingerprint resolveExpression(String body, String retina_name, Double sparsity) throws ApiException {
        block9: {
            if (retina_name == null || body == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/expressions".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(sparsity))) {
                queryParams.put("sparsity", String.valueOf(sparsity));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, body, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        Fingerprint result = (Fingerprint)ApiInvoker.deserialize((String)response, "", Fingerprint.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        Fingerprint result = (Fingerprint)response;
                        return result;
                    }
                    break block9;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    public List<Context> getContextsForExpression(String body, Boolean get_fingerprint, String retina_name, Integer start_index, Integer max_results, Double sparsity) throws ApiException {
        block12: {
            if (retina_name == null || body == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/expressions/contexts".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(start_index))) {
                queryParams.put("start_index", String.valueOf(start_index));
            }
            if (!"null".equals(String.valueOf(max_results))) {
                queryParams.put("max_results", String.valueOf(max_results));
            }
            if (!"null".equals(String.valueOf(sparsity))) {
                queryParams.put("sparsity", String.valueOf(sparsity));
            }
            if (!"null".equals(String.valueOf(get_fingerprint))) {
                queryParams.put("get_fingerprint", String.valueOf(get_fingerprint));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, body, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        List result = (List)ApiInvoker.deserialize((String)response, "Array", Context.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        List result = (List)response;
                        return result;
                    }
                    break block12;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    public List<Term> getSimilarTermsForExpressionContext(String body, Integer context_id, String pos_type, Boolean get_fingerprint, String retina_name, Integer start_index, Integer max_results, Double sparsity) throws ApiException {
        block14: {
            if (retina_name == null || body == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/expressions/similar_terms".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(context_id))) {
                queryParams.put("context_id", String.valueOf(context_id));
            }
            if (!"null".equals(String.valueOf(start_index))) {
                queryParams.put("start_index", String.valueOf(start_index));
            }
            if (!"null".equals(String.valueOf(max_results))) {
                queryParams.put("max_results", String.valueOf(max_results));
            }
            if (!"null".equals(String.valueOf(pos_type))) {
                queryParams.put("pos_type", String.valueOf(pos_type));
            }
            if (!"null".equals(String.valueOf(sparsity))) {
                queryParams.put("sparsity", String.valueOf(sparsity));
            }
            if (!"null".equals(String.valueOf(get_fingerprint))) {
                queryParams.put("get_fingerprint", String.valueOf(get_fingerprint));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, body, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        List result = (List)ApiInvoker.deserialize((String)response, "Array", Term.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        List result = (List)response;
                        return result;
                    }
                    break block14;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    public List<Fingerprint> resolveBulkExpression(String body, String retina_name, Double sparsity) throws ApiException {
        block9: {
            if (retina_name == null || body == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/expressions/bulk".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(sparsity))) {
                queryParams.put("sparsity", String.valueOf(sparsity));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, body, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        List result = (List)ApiInvoker.deserialize((String)response, "Array", Fingerprint.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        List result = (List)response;
                        return result;
                    }
                    break block9;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    public List<List<Context>> getContextsForBulkExpression(String body, Boolean get_fingerprint, String retina_name, Integer start_index, Integer max_results, Double sparsity) throws ApiException {
        block12: {
            if (retina_name == null || body == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/expressions/contexts/bulk".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(start_index))) {
                queryParams.put("start_index", String.valueOf(start_index));
            }
            if (!"null".equals(String.valueOf(max_results))) {
                queryParams.put("max_results", String.valueOf(max_results));
            }
            if (!"null".equals(String.valueOf(sparsity))) {
                queryParams.put("sparsity", String.valueOf(sparsity));
            }
            if (!"null".equals(String.valueOf(get_fingerprint))) {
                queryParams.put("get_fingerprint", String.valueOf(get_fingerprint));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, body, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        List result = (List)ApiInvoker.deserialize((String)response, "Array", Object.class, ApiInvoker.NestedContent.CONTEXT);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        List result = (List)response;
                        return result;
                    }
                    break block12;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    public List<List<Term>> getSimilarTermsForBulkExpressionContext(String body, Integer context_id, String pos_type, Boolean get_fingerprint, String retina_name, Integer start_index, Integer max_results, Double sparsity) throws ApiException {
        block14: {
            if (retina_name == null || body == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/expressions/similar_terms/bulk".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(context_id))) {
                queryParams.put("context_id", String.valueOf(context_id));
            }
            if (!"null".equals(String.valueOf(start_index))) {
                queryParams.put("start_index", String.valueOf(start_index));
            }
            if (!"null".equals(String.valueOf(max_results))) {
                queryParams.put("max_results", String.valueOf(max_results));
            }
            if (!"null".equals(String.valueOf(pos_type))) {
                queryParams.put("pos_type", String.valueOf(pos_type));
            }
            if (!"null".equals(String.valueOf(sparsity))) {
                queryParams.put("sparsity", String.valueOf(sparsity));
            }
            if (!"null".equals(String.valueOf(get_fingerprint))) {
                queryParams.put("get_fingerprint", String.valueOf(get_fingerprint));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, body, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        List result = (List)ApiInvoker.deserialize((String)response, "Array", Object.class, ApiInvoker.NestedContent.TERM);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        List result = (List)response;
                        return result;
                    }
                    break block14;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }
}

