/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.services;

import io.cortical.rest.model.Retina;
import io.cortical.services.RetinaApiUtils;
import io.cortical.services.Retinas;
import io.cortical.services.api.client.ApiException;
import io.cortical.services.api.client.api.RetinasApi;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

class RetinaInfoApiImpl
implements Retinas {
    private final RetinasApi api;

    RetinaInfoApiImpl(String ip, String apiKey) {
        String basePath = RetinaApiUtils.generateBasepath(ip, null);
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new IllegalArgumentException("The apiKey cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)basePath)) {
            throw new IllegalArgumentException("The base path cannot be null.");
        }
        this.api = new RetinasApi(apiKey);
        this.api.setBasePath(basePath);
    }

    RetinaInfoApiImpl(String ip, Short port, String apiKey) {
        String basePath = RetinaApiUtils.generateBasepath(ip, port);
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new IllegalArgumentException("The apiKey cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)basePath)) {
            throw new IllegalArgumentException("The base path cannot be null.");
        }
        this.api = new RetinasApi(apiKey);
        this.api.setBasePath(basePath);
    }

    RetinaInfoApiImpl(RetinasApi api) {
        this.api = api;
    }

    @Override
    public List<Retina> getAllRetinas() throws ApiException {
        return this.api.getRetinas(null);
    }

    @Override
    public Retina retinaByName(String name) throws ApiException {
        List<Retina> retinas = this.api.getRetinas(name);
        if (retinas == null || retinas.size() == 0) {
            return null;
        }
        return retinas.get(0);
    }
}

