/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.cortical.rest.model.Image;
import io.cortical.rest.model.Model;
import io.cortical.services.BaseRetinaApi;
import io.cortical.services.ImageEncoding;
import io.cortical.services.ImagePlotShape;
import io.cortical.services.Images;
import io.cortical.services.api.client.ApiException;
import io.cortical.services.api.client.api.ImageApi;
import java.io.ByteArrayInputStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ImageRetinaApiImpl
extends BaseRetinaApi
implements Images {
    private static final Log LOG = LogFactory.getLog(ImageRetinaApiImpl.class);
    private final ImageApi api;

    ImageRetinaApiImpl(String apiKey, String basePath, String retinaName) {
        super(retinaName);
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new IllegalArgumentException("The apiKey cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)basePath)) {
            throw new IllegalArgumentException("The base path cannot be null.");
        }
        LOG.info((Object)("Initialize Image Retina Api with retina: " + retinaName));
        this.api = new ImageApi(apiKey);
        this.api.setBasePath(basePath);
    }

    ImageRetinaApiImpl(ImageApi api, String retinaName) {
        super(retinaName);
        this.api = api;
    }

    @Override
    public List<Image> getImageBulk(Boolean includeFingerprint, Integer scalar, ImagePlotShape shape, Double sparsity, Model ... models) throws JsonProcessingException, ApiException {
        this.validateRequiredModels(models);
        return this.getImageBulk(includeFingerprint, scalar, shape, sparsity, this.toJson(models));
    }

    @Override
    public ByteArrayInputStream getImage(Integer scalar, ImagePlotShape shape, ImageEncoding imageEncoding, Double sparsity, Model model) throws JsonProcessingException, ApiException {
        this.validateRequiredModels(model);
        return this.getImage(scalar, shape, imageEncoding, sparsity, model.toJson());
    }

    @Override
    public ByteArrayInputStream compare(Integer scalar, ImagePlotShape shape, ImageEncoding imageEncoding, Model model1, Model model2) throws JsonProcessingException, ApiException {
        Model[] models = new Model[]{model1, model2};
        this.validateRequiredModels(models);
        return this.compare(scalar, shape, imageEncoding, this.toJson(models));
    }

    @Override
    public List<Image> getImageBulk(ImagePlotShape shape, Double sparsity, Model ... models) throws JsonProcessingException, ApiException {
        return this.getImageBulk(null, null, shape, sparsity, models);
    }

    @Override
    public List<Image> getImageBulk(Model ... models) throws JsonProcessingException, ApiException {
        return this.getImageBulk((ImagePlotShape)null, (Double)null, models);
    }

    @Override
    public ByteArrayInputStream getImage(ImagePlotShape shape, Double sparsity, Model model) throws JsonProcessingException, ApiException {
        return this.getImage(null, shape, null, sparsity, model);
    }

    @Override
    public ByteArrayInputStream getImage(Model model) throws JsonProcessingException, ApiException {
        return this.getImage(null, null, model);
    }

    @Override
    public ByteArrayInputStream compare(ImagePlotShape shape, ImageEncoding imageEncoding, Model model1, Model model2) throws JsonProcessingException, ApiException {
        return this.compare(null, shape, imageEncoding, model1, model2);
    }

    @Override
    public ByteArrayInputStream compare(Model model1, Model model2) throws JsonProcessingException, ApiException {
        return this.compare(null, null, model1, model2);
    }

    @Override
    public List<Image> getImageBulk(Boolean includeFingerprint, Integer scalar, ImagePlotShape shape, Double sparsity, String jsonModel) throws JsonProcessingException, ApiException {
        LOG.debug((Object)("Retrieve images for bulk expressions: model: " + jsonModel + "  scalar: " + scalar + "  sparsity: " + sparsity + "  shape: " + this.name(shape) + "  include fingerprint: " + includeFingerprint));
        String shapeString = null;
        if (shape != null) {
            shapeString = shape.name().toLowerCase();
        }
        return this.api.getImageForBulkExpressions(jsonModel, includeFingerprint, this.retinaName, scalar, shapeString, sparsity);
    }

    @Override
    public ByteArrayInputStream getImage(Integer scalar, ImagePlotShape shape, ImageEncoding imageEncoding, Double sparsity, String jsonModel) throws JsonProcessingException, ApiException {
        LOG.debug((Object)("Retrieve image for expression: model: " + jsonModel + "  scalar: " + scalar + "  sparsity: " + sparsity + "  shape: " + this.name(shape) + "  image encoding: " + this.name(imageEncoding)));
        String shapeString = null;
        if (shape != null) {
            shapeString = shape.name().toLowerCase();
        }
        String encodingString = null;
        if (imageEncoding != null) {
            encodingString = imageEncoding.machineRepresentation();
        }
        return this.api.getImageForExpression(jsonModel, this.retinaName, scalar, shapeString, encodingString, sparsity);
    }

    @Override
    public ByteArrayInputStream compare(Integer scalar, ImagePlotShape shape, ImageEncoding imageEncoding, String jsonModel) throws JsonProcessingException, ApiException {
        LOG.debug((Object)("Retrieve image for expression: model: " + jsonModel + "  scalar: " + scalar + "  shape: " + this.name(shape) + "  image encoding: " + this.name(imageEncoding)));
        String shapeString = null;
        if (shape != null) {
            shapeString = shape.name().toLowerCase();
        }
        String encodingString = null;
        if (imageEncoding != null) {
            encodingString = imageEncoding.machineRepresentation();
        }
        return this.api.getOverlayImage(jsonModel, this.retinaName, shapeString, scalar, encodingString);
    }

    @Override
    public List<Image> getImageBulk(ImagePlotShape shape, Double sparsity, String jsonModels) throws JsonProcessingException, ApiException {
        return this.getImageBulk(null, null, shape, sparsity, jsonModels);
    }

    @Override
    public List<Image> getImageBulk(String jsonModels) throws JsonProcessingException, ApiException {
        return this.getImageBulk(null, null, jsonModels);
    }

    @Override
    public ByteArrayInputStream getImage(ImagePlotShape shape, Double sparsity, String jsonModels) throws JsonProcessingException, ApiException {
        return this.getImage(null, shape, null, sparsity, jsonModels);
    }

    @Override
    public ByteArrayInputStream getImage(String jsonModels) throws JsonProcessingException, ApiException {
        return this.getImage(null, null, jsonModels);
    }

    @Override
    public ByteArrayInputStream compare(ImagePlotShape shape, ImageEncoding imageEncoding, String jsonModels) throws JsonProcessingException, ApiException {
        return this.compare(null, shape, imageEncoding, jsonModels);
    }

    @Override
    public ByteArrayInputStream compare(String jsonModels) throws JsonProcessingException, ApiException {
        return this.compare(null, null, jsonModels);
    }

    private String name(Enum<?> enumItem) {
        if (enumItem != null) {
            return enumItem.name();
        }
        return null;
    }
}

