/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.cortical.rest.model.Context;
import io.cortical.rest.model.Fingerprint;
import io.cortical.rest.model.Model;
import io.cortical.rest.model.Term;
import io.cortical.services.BaseRetinaApi;
import io.cortical.services.Expressions;
import io.cortical.services.Pagination;
import io.cortical.services.PosType;
import io.cortical.services.api.client.ApiException;
import io.cortical.services.api.client.api.ExpressionsApi;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ExpressionsRetinaApiImpl
extends BaseRetinaApi
implements Expressions {
    private static final Log LOG = LogFactory.getLog(ExpressionsRetinaApiImpl.class);
    private final ExpressionsApi expressionsApi;

    ExpressionsRetinaApiImpl(String apiKey, String basePath, String retinaName) {
        super(retinaName);
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new IllegalArgumentException("The apiKey cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)basePath)) {
            throw new IllegalArgumentException("The base path cannot be null.");
        }
        LOG.info((Object)("Initialize Expressions Retina Api with retina: " + retinaName));
        this.expressionsApi = new ExpressionsApi(apiKey);
        this.expressionsApi.setBasePath(basePath);
    }

    ExpressionsRetinaApiImpl(ExpressionsApi expressionsApi, String retinaName) {
        super(retinaName);
        this.expressionsApi = expressionsApi;
    }

    @Override
    public List<List<Term>> getSimilarTermsBulk(Integer contextId, PosType posType, Pagination pagination, Boolean includeFingerprint, Double sparsity, Model ... models) throws JsonProcessingException, ApiException {
        this.validateRequiredModels(models);
        return this.getSimilarTermsBulk(contextId, posType, pagination, includeFingerprint, sparsity, this.toJson(models));
    }

    @Override
    public List<Fingerprint> resolveBulk(Double sparsity, Model ... models) throws JsonProcessingException, ApiException {
        this.validateRequiredModels(models);
        LOG.debug((Object)("Resolve bulk expression for models: " + this.toJson(models) + "  sparsity: " + sparsity));
        return this.expressionsApi.resolveBulkExpression(this.toJson(models), this.retinaName, sparsity);
    }

    @Override
    public List<List<Context>> getContextsBulk(Pagination pagination, Boolean includeFingerprint, Double sparsity, Model ... models) throws JsonProcessingException, ApiException {
        this.validateRequiredModels(models);
        return this.getContextsBulk(pagination, includeFingerprint, sparsity, this.toJson(models));
    }

    @Override
    public Fingerprint resolve(Double sparsity, Model model) throws JsonProcessingException, ApiException {
        this.validateRequiredModels(model);
        LOG.debug((Object)("Resolve expression for model: " + model.toJson()));
        return this.expressionsApi.resolveExpression(model.toJson(), this.retinaName, sparsity);
    }

    @Override
    public List<Context> getContexts(Pagination pagination, Boolean includeFingerprint, Double sparsity, Model model) throws JsonProcessingException, ApiException {
        this.validateRequiredModels(model);
        return this.getContexts(pagination, includeFingerprint, sparsity, model.toJson());
    }

    @Override
    public List<Term> getSimilarTerms(Integer contextId, PosType posType, Pagination pagination, Boolean includeFingerprint, Double sparsity, Model model) throws JsonProcessingException, ApiException {
        this.validateRequiredModels(model);
        return this.getSimilarTerms(contextId, posType, pagination, includeFingerprint, sparsity, model.toJson());
    }

    @Override
    public List<List<Term>> getSimilarTermsBulk(Integer contextId, PosType posType, Boolean includeFingerprint, Double sparsity, Model ... models) throws JsonProcessingException, ApiException {
        return this.getSimilarTermsBulk(contextId, posType, null, includeFingerprint, sparsity, models);
    }

    @Override
    public List<List<Term>> getSimilarTermsBulk(Integer contextId, PosType posType, Double sparsity, Model ... models) throws JsonProcessingException, ApiException {
        return this.getSimilarTermsBulk(contextId, posType, null, sparsity, models);
    }

    @Override
    public List<List<Term>> getSimilarTermsBulk(Integer contextId, PosType posType, Boolean includeFingerprint, Model ... models) throws JsonProcessingException, ApiException {
        return this.getSimilarTermsBulk(contextId, posType, includeFingerprint, (Double)null, models);
    }

    @Override
    public List<List<Term>> getSimilarTermsBulk(Integer contextId, PosType posType, Model ... models) throws JsonProcessingException, ApiException {
        return this.getSimilarTermsBulk(contextId, posType, (Boolean)null, (Double)null, models);
    }

    @Override
    public List<Fingerprint> resolveBulk(Model ... models) throws JsonProcessingException, ApiException {
        return this.resolveBulk((Double)null, models);
    }

    @Override
    public List<List<Context>> getContextsBulk(Boolean includeFingerprint, Double sparsity, Model ... models) throws JsonProcessingException, ApiException {
        return this.getContextsBulk(null, includeFingerprint, sparsity, models);
    }

    @Override
    public List<List<Context>> getContextsBulk(Double sparsity, Model ... models) throws JsonProcessingException, ApiException {
        return this.getContextsBulk(null, sparsity, models);
    }

    @Override
    public List<List<Context>> getContextsBulk(Boolean includeFingerprint, Model ... models) throws JsonProcessingException, ApiException {
        return this.getContextsBulk(includeFingerprint, (Double)null, models);
    }

    @Override
    public List<List<Context>> getContextsBulk(Model ... models) throws JsonProcessingException, ApiException {
        return this.getContextsBulk((Boolean)null, (Double)null, models);
    }

    @Override
    public Fingerprint resolve(Model model) throws JsonProcessingException, ApiException {
        return this.resolve(null, model);
    }

    @Override
    public List<Context> getContexts(Boolean includeFingerprint, Double sparsity, Model model) throws JsonProcessingException, ApiException {
        return this.getContexts(null, includeFingerprint, sparsity, model);
    }

    @Override
    public List<Context> getContexts(Double sparsity, Model model) throws JsonProcessingException, ApiException {
        return this.getContexts(null, sparsity, model);
    }

    @Override
    public List<Context> getContexts(Boolean includeFingerprint, Model model) throws JsonProcessingException, ApiException {
        return this.getContexts(includeFingerprint, null, model);
    }

    @Override
    public List<Context> getContexts(Model model) throws JsonProcessingException, ApiException {
        return this.getContexts(null, null, model);
    }

    @Override
    public List<Term> getSimilarTerms(Integer contextId, PosType posType, Boolean includeFingerprint, Double sparsity, Model model) throws JsonProcessingException, ApiException {
        return this.getSimilarTerms(contextId, posType, null, includeFingerprint, sparsity, model);
    }

    @Override
    public List<Term> getSimilarTerms(Integer contextId, PosType posType, Double sparsity, Model model) throws JsonProcessingException, ApiException {
        return this.getSimilarTerms(contextId, posType, null, sparsity, model);
    }

    @Override
    public List<Term> getSimilarTerms(Integer contextId, PosType posType, Boolean includeFingerprint, Model model) throws JsonProcessingException, ApiException {
        return this.getSimilarTerms(contextId, posType, includeFingerprint, null, model);
    }

    @Override
    public List<Term> getSimilarTerms(Integer contextId, PosType posType, Model model) throws JsonProcessingException, ApiException {
        return this.getSimilarTerms(contextId, posType, null, null, model);
    }

    @Override
    public List<List<Term>> getSimilarTermsBulk(Integer contextId, PosType posType, Pagination pagination, Boolean includeFingerprint, Double sparsity, String jsonModel) throws JsonProcessingException, ApiException {
        pagination = this.initPagination(pagination);
        String posTypeName = null;
        if (posType != null) {
            posTypeName = posType.name();
        }
        LOG.debug((Object)("Retrieve similar terms for bulk expression: model: " + jsonModel + " pagination: " + pagination.toString() + "  sparsity: " + sparsity + "  include fingerprint: " + includeFingerprint));
        return this.expressionsApi.getSimilarTermsForBulkExpressionContext(jsonModel, contextId, posTypeName, includeFingerprint, this.retinaName, pagination.getStartIndex(), pagination.getMaxResults(), sparsity);
    }

    @Override
    public List<Fingerprint> resolveBulk(Double sparsity, String jsonModels) throws JsonProcessingException, ApiException {
        LOG.debug((Object)("Resolve bulk expression for models: " + jsonModels + "  sparsity: " + sparsity));
        return this.expressionsApi.resolveBulkExpression(jsonModels, this.retinaName, sparsity);
    }

    @Override
    public List<List<Context>> getContextsBulk(Pagination pagination, Boolean includeFingerprint, Double sparsity, String jsonModels) throws JsonProcessingException, ApiException {
        pagination = this.initPagination(pagination);
        LOG.debug((Object)("Retrieve contexts for bulk expression: " + jsonModels + " pagination: " + pagination.toString() + "  sparsity: " + sparsity + "  include fingerprint: " + includeFingerprint));
        return this.expressionsApi.getContextsForBulkExpression(jsonModels, includeFingerprint, this.retinaName, pagination.getStartIndex(), pagination.getMaxResults(), sparsity);
    }

    @Override
    public Fingerprint resolve(Double sparsity, String jsonModel) throws JsonProcessingException, ApiException {
        LOG.debug((Object)("Resolve expression for model: " + jsonModel));
        return this.expressionsApi.resolveExpression(jsonModel, this.retinaName, sparsity);
    }

    @Override
    public List<Context> getContexts(Pagination pagination, Boolean includeFingerprint, Double sparsity, String jsonModel) throws JsonProcessingException, ApiException {
        pagination = this.initPagination(pagination);
        LOG.debug((Object)("Retrieve contexts for expression: model: " + jsonModel + " pagination: " + pagination.toString() + "  sparsity: " + sparsity + "  include fingerprint: " + includeFingerprint));
        return this.expressionsApi.getContextsForExpression(jsonModel, includeFingerprint, this.retinaName, pagination.getStartIndex(), pagination.getMaxResults(), sparsity);
    }

    @Override
    public List<Term> getSimilarTerms(Integer contextId, PosType posType, Pagination pagination, Boolean includeFingerprint, Double sparsity, String jsonModel) throws JsonProcessingException, ApiException {
        pagination = this.initPagination(pagination);
        String posTypeName = null;
        if (posType != null) {
            posTypeName = posType.name();
        }
        LOG.debug((Object)("Retrieve similar terms for model: " + jsonModel + " pagination: " + pagination.toString() + "  sparsity: " + sparsity + "  include fingerprint: " + includeFingerprint));
        return this.expressionsApi.getSimilarTermsForExpressionContext(jsonModel, contextId, posTypeName, includeFingerprint, this.retinaName, pagination.getStartIndex(), pagination.getMaxResults(), sparsity);
    }

    @Override
    public List<List<Term>> getSimilarTermsBulk(Integer contextId, PosType posType, Boolean includeFingerprint, Double sparsity, String jsonModel) throws JsonProcessingException, ApiException {
        return this.getSimilarTermsBulk(contextId, posType, null, includeFingerprint, sparsity, jsonModel);
    }

    @Override
    public List<List<Term>> getSimilarTermsBulk(Integer contextId, PosType posType, Double sparsity, String jsonModel) throws JsonProcessingException, ApiException {
        return this.getSimilarTermsBulk(contextId, posType, null, sparsity, jsonModel);
    }

    @Override
    public List<List<Term>> getSimilarTermsBulk(Integer contextId, PosType posType, Boolean includeFingerprint, String jsonModel) throws JsonProcessingException, ApiException {
        return this.getSimilarTermsBulk(contextId, posType, includeFingerprint, null, jsonModel);
    }

    @Override
    public List<List<Term>> getSimilarTermsBulk(Integer contextId, PosType posType, String jsonModel) throws JsonProcessingException, ApiException {
        return this.getSimilarTermsBulk(contextId, posType, null, null, jsonModel);
    }

    @Override
    public List<Fingerprint> resolveBulk(String jsonModel) throws JsonProcessingException, ApiException {
        return this.resolveBulk(null, jsonModel);
    }

    @Override
    public List<List<Context>> getContextsBulk(Boolean includeFingerprint, Double sparsity, String jsonModel) throws JsonProcessingException, ApiException {
        return this.getContextsBulk(null, includeFingerprint, sparsity, jsonModel);
    }

    @Override
    public List<List<Context>> getContextsBulk(Double sparsity, String jsonModel) throws JsonProcessingException, ApiException {
        return this.getContextsBulk(null, sparsity, jsonModel);
    }

    @Override
    public List<List<Context>> getContextsBulk(Boolean includeFingerprint, String jsonModel) throws JsonProcessingException, ApiException {
        return this.getContextsBulk(includeFingerprint, null, jsonModel);
    }

    @Override
    public List<List<Context>> getContextsBulk(String jsonModel) throws JsonProcessingException, ApiException {
        return this.getContextsBulk(null, null, jsonModel);
    }

    @Override
    public Fingerprint resolve(String jsonModel) throws JsonProcessingException, ApiException {
        return this.resolve(null, jsonModel);
    }

    @Override
    public List<Context> getContexts(Boolean includeFingerprint, Double sparsity, String jsonModel) throws JsonProcessingException, ApiException {
        return this.getContexts(null, includeFingerprint, sparsity, jsonModel);
    }

    @Override
    public List<Context> getContexts(Double sparsity, String jsonModel) throws JsonProcessingException, ApiException {
        return this.getContexts(null, sparsity, jsonModel);
    }

    @Override
    public List<Context> getContexts(Boolean includeFingerprint, String jsonModel) throws JsonProcessingException, ApiException {
        return this.getContexts(includeFingerprint, null, jsonModel);
    }

    @Override
    public List<Context> getContexts(String jsonModel) throws JsonProcessingException, ApiException {
        return this.getContexts(null, null, jsonModel);
    }

    @Override
    public List<Term> getSimilarTerms(Integer contextId, PosType posType, Boolean includeFingerprint, Double sparsity, String jsonModel) throws JsonProcessingException, ApiException {
        return this.getSimilarTerms(contextId, posType, null, includeFingerprint, sparsity, jsonModel);
    }

    @Override
    public List<Term> getSimilarTerms(Integer contextId, PosType posType, Double sparsity, String jsonModel) throws JsonProcessingException, ApiException {
        return this.getSimilarTerms(contextId, posType, null, sparsity, jsonModel);
    }

    @Override
    public List<Term> getSimilarTerms(Integer contextId, PosType posType, Boolean includeFingerprint, String jsonModel) throws JsonProcessingException, ApiException {
        return this.getSimilarTerms(contextId, posType, includeFingerprint, null, jsonModel);
    }

    @Override
    public List<Term> getSimilarTerms(Integer contextId, PosType posType, String jsonModel) throws JsonProcessingException, ApiException {
        return this.getSimilarTerms(contextId, posType, null, null, jsonModel);
    }

    @Override
    public List<List<Term>> getSimilarTermsBulk(PosType posType, Model ... models) throws JsonProcessingException, ApiException {
        return this.getSimilarTermsBulk(null, posType, models);
    }

    @Override
    public List<List<Term>> getSimilarTermsBulk(Integer contextId, Model ... models) throws JsonProcessingException, ApiException {
        return this.getSimilarTermsBulk(contextId, (PosType)null, models);
    }

    @Override
    public List<List<Term>> getSimilarTermsBulk(Model ... models) throws JsonProcessingException, ApiException {
        return this.getSimilarTermsBulk((Integer)null, (PosType)null, models);
    }

    @Override
    public List<List<Term>> getSimilarTermsBulk(PosType posType, String jsonModel) throws JsonProcessingException, ApiException {
        return this.getSimilarTermsBulk(null, posType, jsonModel);
    }

    @Override
    public List<List<Term>> getSimilarTermsBulk(Integer contextId, String jsonModel) throws JsonProcessingException, ApiException {
        return this.getSimilarTermsBulk(contextId, null, jsonModel);
    }

    @Override
    public List<List<Term>> getSimilarTermsBulk(String jsonModel) throws JsonProcessingException, ApiException {
        return this.getSimilarTermsBulk(null, null, jsonModel);
    }

    @Override
    public List<Term> getSimilarTerms(PosType posType, Model model) throws JsonProcessingException, ApiException {
        return this.getSimilarTerms(null, posType, model);
    }

    @Override
    public List<Term> getSimilarTerms(Integer contextId, Model model) throws JsonProcessingException, ApiException {
        return this.getSimilarTerms(contextId, null, model);
    }

    @Override
    public List<Term> getSimilarTerms(Model model) throws JsonProcessingException, ApiException {
        return this.getSimilarTerms(null, null, model);
    }

    @Override
    public List<Term> getSimilarTerms(PosType posType, String jsonModel) throws JsonProcessingException, ApiException {
        return this.getSimilarTerms(null, posType, jsonModel);
    }

    @Override
    public List<Term> getSimilarTerms(Integer contextId, String jsonModel) throws JsonProcessingException, ApiException {
        return this.getSimilarTerms(contextId, null, jsonModel);
    }

    @Override
    public List<Term> getSimilarTerms(String jsonModel) throws JsonProcessingException, ApiException {
        return this.getSimilarTerms(null, null, jsonModel);
    }
}

