/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.services;

import io.cortical.rest.model.CategoryFilter;
import io.cortical.services.BaseRetinaApi;
import io.cortical.services.Classify;
import io.cortical.services.api.client.ApiException;
import io.cortical.services.api.client.api.ClassifyApi;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassifyRetinaApiImpl
extends BaseRetinaApi
implements Classify {
    private static final Log LOG = LogFactory.getLog(ClassifyRetinaApiImpl.class);
    private final ClassifyApi api;

    ClassifyRetinaApiImpl(String apiKey, String basePath, String retinaName) {
        super(retinaName);
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new IllegalArgumentException("The apiKey cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)basePath)) {
            throw new IllegalArgumentException("The base path cannot be null.");
        }
        LOG.info((Object)("Initialize Classify Retina Api with retina: " + retinaName));
        this.api = new ClassifyApi(apiKey);
        this.api.setBasePath(basePath);
    }

    ClassifyRetinaApiImpl(ClassifyApi api, String retinaName) {
        super(retinaName);
        this.api = api;
    }

    @Override
    public CategoryFilter createCategoryFilter(String filter_name, String body) throws ApiException {
        if (StringUtils.isEmpty((CharSequence)filter_name) || body == null) {
            throw new IllegalArgumentException("The text cannot be null.");
        }
        LOG.debug((Object)("Retrieve CategoryFilter: " + body));
        return this.api.createCategoryFilter(filter_name, body, this.retinaName);
    }
}

