/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.services.api.client.api;

import io.cortical.rest.model.Image;
import io.cortical.services.api.client.ApiException;
import io.cortical.services.api.client.ApiInvoker;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;

public class ImageApi {
    private String basePath = "http://api.cortical.io/rest";
    private String key = "replaceWithRetinaAPIKey";
    private ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public ImageApi(String apiKey) {
        this.key = apiKey;
        this.apiInvoker.addDefaultHeader("api-key", apiKey);
    }

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ByteArrayInputStream getImageForExpression(String body, String retina_name, Integer image_scalar, String plot_shape, String image_encoding, Double sparsity) throws ApiException {
        block12: {
            if (retina_name == null || body == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/image".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(image_scalar))) {
                queryParams.put("image_scalar", String.valueOf(image_scalar));
            }
            if (!"null".equals(String.valueOf(plot_shape))) {
                queryParams.put("plot_shape", String.valueOf(plot_shape));
            }
            if (!"null".equals(String.valueOf(image_encoding))) {
                queryParams.put("image_encoding", String.valueOf(image_encoding));
            }
            if (!"null".equals(String.valueOf(sparsity))) {
                queryParams.put("sparsity", String.valueOf(sparsity));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, body, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        ByteArrayInputStream result = (ByteArrayInputStream)ApiInvoker.deserialize((String)response, "", ByteArrayInputStream.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        ByteArrayInputStream result = (ByteArrayInputStream)response;
                        return result;
                    }
                    break block12;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    public ByteArrayInputStream getOverlayImage(String body, String retina_name, String plot_shape, Integer image_scalar, String image_encoding) throws ApiException {
        block11: {
            if (retina_name == null || body == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/image/compare".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(plot_shape))) {
                queryParams.put("plot_shape", String.valueOf(plot_shape));
            }
            if (!"null".equals(String.valueOf(image_scalar))) {
                queryParams.put("image_scalar", String.valueOf(image_scalar));
            }
            if (!"null".equals(String.valueOf(image_encoding))) {
                queryParams.put("image_encoding", String.valueOf(image_encoding));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, body, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        ByteArrayInputStream result = (ByteArrayInputStream)ApiInvoker.deserialize((String)response, "", ByteArrayInputStream.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        ByteArrayInputStream result = (ByteArrayInputStream)response;
                        return result;
                    }
                    break block11;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    public List<Image> getImageForBulkExpressions(String body, Boolean get_fingerprint, String retina_name, Integer image_scalar, String plot_shape, Double sparsity) throws ApiException {
        block12: {
            if (retina_name == null || body == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/image/bulk".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(image_scalar))) {
                queryParams.put("image_scalar", String.valueOf(image_scalar));
            }
            if (!"null".equals(String.valueOf(plot_shape))) {
                queryParams.put("plot_shape", String.valueOf(plot_shape));
            }
            if (!"null".equals(String.valueOf(sparsity))) {
                queryParams.put("sparsity", String.valueOf(sparsity));
            }
            if (!"null".equals(String.valueOf(get_fingerprint))) {
                queryParams.put("get_fingerprint", String.valueOf(get_fingerprint));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, body, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        List result = (List)ApiInvoker.deserialize((String)response, "Array", Image.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        List result = (List)response;
                        return result;
                    }
                    break block12;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }
}

