/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.services.api.client.api;

import io.cortical.rest.model.Fingerprint;
import io.cortical.services.api.client.ApiException;
import io.cortical.services.api.client.ApiInvoker;
import java.io.ByteArrayInputStream;
import java.util.HashMap;

public class FingerprintsApi {
    private String basePath = "http://api.cortical.io/rest";
    private String key = "replaceWithRetinaAPIKey";
    private ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public FingerprintsApi(String apiKey) {
        this.key = apiKey;
        this.apiInvoker.addDefaultHeader("api-key", apiKey);
    }

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public Fingerprint getFingerprint(String retina_name, String fingerprint_id) throws ApiException {
        block9: {
            if (retina_name == null || fingerprint_id == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/fingerprints".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(fingerprint_id))) {
                queryParams.put("fingerprint_id", String.valueOf(fingerprint_id));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, null, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        Fingerprint result = (Fingerprint)ApiInvoker.deserialize((String)response, "", Fingerprint.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        Fingerprint result = (Fingerprint)response;
                        return result;
                    }
                    break block9;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    public Fingerprint getLogicalFingerprint(String retina_name, String logical_name) throws ApiException {
        block9: {
            if (retina_name == null || logical_name == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/fingerprints/byName".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(logical_name))) {
                queryParams.put("logical_name", String.valueOf(logical_name));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, null, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        Fingerprint result = (Fingerprint)ApiInvoker.deserialize((String)response, "", Fingerprint.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        Fingerprint result = (Fingerprint)response;
                        return result;
                    }
                    break block9;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    public void updateFingerprint(String retina_name, String fingerprint_id, String name) throws ApiException {
        block10: {
            if (retina_name == null || fingerprint_id == null || name == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/fingerprints/update".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(fingerprint_id))) {
                queryParams.put("fingerprint_id", String.valueOf(fingerprint_id));
            }
            if (!"null".equals(String.valueOf(name))) {
                queryParams.put("name", String.valueOf(name));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "PUT", queryParams, null, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        return;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        return;
                    }
                    break block10;
                }
                return;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return;
                }
                throw ex;
            }
        }
    }

    public void deleteFingerprint(String retina_name, String fingerprint_id) throws ApiException {
        block9: {
            if (retina_name == null || fingerprint_id == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/fingerprints/delete".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            if (!"null".equals(String.valueOf(fingerprint_id))) {
                queryParams.put("fingerprint_id", String.valueOf(fingerprint_id));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "DELETE", queryParams, null, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        return;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        return;
                    }
                    break block9;
                }
                return;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return;
                }
                throw ex;
            }
        }
    }
}

