/*
 * Decompiled with CFR 0.152.
 */
package io.cortical.services.api.client.api;

import io.cortical.rest.model.Metric;
import io.cortical.services.api.client.ApiException;
import io.cortical.services.api.client.ApiInvoker;
import java.io.ByteArrayInputStream;
import java.util.HashMap;

public class CompareApi {
    private String basePath = "http://api.cortical.io/rest";
    private String key = "replaceWithRetinaAPIKey";
    private ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public CompareApi(String apiKey) {
        this.key = apiKey;
        this.apiInvoker.addDefaultHeader("api-key", apiKey);
    }

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public Metric compare(String body, String retina_name) throws ApiException {
        block8: {
            if (retina_name == null || body == null) {
                throw new ApiException(400, "missing required params");
            }
            String path = "/compare".replaceAll("\\{format\\}", "json");
            HashMap<String, String> queryParams = new HashMap<String, String>();
            HashMap<String, String> headerParams = new HashMap<String, String>();
            if (!"null".equals(String.valueOf(retina_name))) {
                queryParams.put("retina_name", String.valueOf(retina_name));
            }
            String contentType = "application/json";
            try {
                Object response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, body, headerParams, contentType);
                if (response != null) {
                    if (response instanceof String) {
                        Metric result = (Metric)ApiInvoker.deserialize((String)response, "", Metric.class, null);
                        return result;
                    }
                    if (response instanceof ByteArrayInputStream) {
                        Metric result = (Metric)response;
                        return result;
                    }
                    break block8;
                }
                return null;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }
}

